package cn.quantgroup.cashloanflowboss.spi.clf.entity;

import cn.quantgroup.cashloanflowboss.spi.clf.model.EncType;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by wudi on 2016/11/28.
 */
@Data
@Entity
@Table(name = "channel_configuration", catalog = "cash_loan_flow")
public class ChannelConfiguration implements Serializable {
    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "channel_name")
    private String channelName;

    @Column(name = "channel_code")
    private String channelCode;


    @Column(name = "registered_from")
    private Long registeredFrom;

    /**
     * 默认有效
     */
    @Column(name = "is_active")
    private Boolean isActive = Boolean.TRUE;

    @Column(name = "created_at")
    private Timestamp createdAt = new Timestamp(System.currentTimeMillis());

    /**
     * 请求是否使用标准api
     */
    @Column(name = "is_request_standard")
    private Boolean isRequestStandard = Boolean.FALSE;

    /**
     * 加密类型
     */
    @Column(name = "enc_type")
    private EncType encType = EncType.AES;

    /**
     * aes加密key
     */
    @Column(name = "aes_key")
    private String aesKey;

    /**
     * md5摘要key
     */
    @Column(name = "md5_key")
    private String md5Key;

    /**
     * 授信中心channelCode, 爬虫提交channelCode
     */
    @Column(name = "spider_center_channel_code")
    private String spiderCenterChannelCode;

    
    /**
     * 授信中心商户渠道channelCode，授信授权提交channelCode
     */
    @Column(name = "spider_center_merchant_channel_code")
    private String spiderCenterMerchantChannelCode;

    /**
     * 渠道认证选项
     */
    @Column(name = "auth_option")
    private String authOption;

    /**
     * 免密登陆跳转url
     */
    @Column(name = "login_page_url")
    private String loginPageUrl;

}