package cn.quantgroup.cashloanflowboss.utils;

import java.util.Random;
import java.util.UUID;

/**
 * Created by WeiWei on 2017/9/28.
 */
public class RandomTools {

    /**
     * 获取随机UUID，32位
     *
     * @return
     */
    public static String getUUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    /**
     * 获取随机字符串
     *
     * @param length
     * @param seeds
     * @return
     */
    public static String getRandomString(int length, String... seeds) {

        Random random = new Random();

        StringBuilder result = new StringBuilder();

        for (int i = 0; i < length; i++) {
            result.append(seeds[seeds.length == 1 ? 0 : random.nextInt(seeds.length)]);
        }

        return result.toString();

    }

    /**
     * 获取范围随机整数
     *
     * @param min
     * @param max
     * @return
     */
    public static int getRandomInteger(int min, int max) {
        return new Random().nextInt(max - min + 1) + min;
    }

}
