package cn.quantgroup.cashloanflowboss.spi.clf.service;

import cn.quantgroup.cashloanflowboss.api.order.model.OrderBaseModel;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.*;
import cn.quantgroup.cashloanflowboss.spi.clf.repository.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.Predicate;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * function:
 * date: 2019/9/3
 *
 * @author: suntao
 */
@Service
public class CLFCenterServiceImpl implements CLFCenterService {


    @Autowired
    private CLFCenter clfCenter;

    @Autowired
    private CallbackFailRecordRepository callbackFailRecordRepository;
    @Autowired
    private CallbackRecordRepository callbackRecordRepository;
    @Autowired
    private ClfOrderMappingRepository orderMappingRepository;
    @Autowired
    private ClfChannelConfigurationRepository clfChannelConfigurationRepository;
    @Autowired
    private ClfCallbackConfigurationRepository clfCallbackConfigurationRepository;
    @Autowired
    private ApplyRequestHistoryRepository applyRequestHistoryRepository;
    @Autowired
    private WithdrawRecordRepository withdrawRecordRepository;
    @Autowired
    private ClfOrderCallbackRepository clfOrderCallbackRepository;

    @Autowired
    private ChannelApplyInfoStrategyRepository channelApplyInfoStrategyRepository;


    @Autowired
    private ICallbackConfigurationRepository callbackConfigurationRepository;


    @Override
    public List<CallbackFailRecord> findCallbackFailRecordByApplyNo(String applyNo) {
        return callbackFailRecordRepository.findByApplyNo(applyNo);
    }

    @Override
    public List<CallbackRecord> findCallbackRecordByApplyNo(String applyNo) {
        return callbackRecordRepository.findByApplyNo(applyNo);
    }

    @Override
    public ClfOrderMapping findOrderMappingByChannelOrderNo(String channelOrderNumber) {
        return orderMappingRepository.findByChannelOrderNoLastOne(channelOrderNumber);
    }

    @Override
    public List<WithdrawRecord> findWithdrawRecordList(String channelOrderNumber, Long channelId) {
        return withdrawRecordRepository.findByChannelOrderNoAndChannelId(channelOrderNumber, channelId);
    }

    @Override
    public List<ApplyRequestHistory> findApplyRequestHistoryBySpecification(OrderBaseModel orderBaseModel) {
        List<ApplyRequestHistory> all = applyRequestHistoryRepository.findAll(((root, criteriaQuery, criteriaBuilder) -> {
            List<Predicate> predicates = new ArrayList<>();

            // 指定渠道号
            if (Objects.nonNull(orderBaseModel.getChannelId())) {
                predicates.add(criteriaBuilder.equal(root.get("channelId"), orderBaseModel.getChannelId().longValue()));
            }
            if (StringUtils.isNotEmpty(orderBaseModel.getChannelOrderNumber())) {
                predicates.add(criteriaBuilder.equal(root.get("channelOrderNo"), orderBaseModel.getChannelOrderNumber()));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();
        }));
        return all;
    }

    @Override
    public Page<ClfChannelConfiguration> findChannelConfigurationByCriteriaQueryPage(Integer pageNumber, Integer pageSize, Long channelId, String channelName) {
        return clfChannelConfigurationRepository.findAll((root, criteriaQuery, criteriaBuilder) -> {

            List<Predicate> predicates = new ArrayList<>();

            // 指定渠道号
            if (Objects.nonNull(channelId)) {
                predicates.add(criteriaBuilder.equal(root.get("registeredFrom"), channelId.longValue()));
            }

            if (StringUtils.isNotEmpty(channelName)) {
                predicates.add(criteriaBuilder.like(root.get("channelName"), "%" + channelName + "%"));
            }

            // 设置查询条件
            criteriaQuery.where(criteriaBuilder.and(predicates.toArray(new Predicate[predicates.size()])));
            // 指定排序
            criteriaQuery.orderBy(criteriaBuilder.desc(root.get("id")));

            return criteriaQuery.getRestriction();

        }, new PageRequest(pageNumber, pageSize));
    }

    @Override
    public ClfChannelConfiguration findChannelConfigurationByChannelId(Long channelId) {
        return clfChannelConfigurationRepository.findByRegisteredFrom(channelId);
    }

    @Override
    public void saveChannelConfiguration(ClfChannelConfiguration channelConfiguration) {
        channelConfiguration.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
        clfChannelConfigurationRepository.save(channelConfiguration);
    }

    @Override
    public void saveCallbackConfiguration(ClfCallbackConfiguration clfCallbackConfiguration) {
        clfCallbackConfigurationRepository.save(clfCallbackConfiguration);
    }

    @Override
    public void saveOrderCall(List<ClfOrderCallBack> clfOrderCallBackList) {
        clfOrderCallbackRepository.save(clfOrderCallBackList);
    }

    @Override
    public ClfOrderCallBack findOrderCallBackByByCallbackStatusAndChannelId(String kaNoticeName, Long channelId) {
        return clfOrderCallbackRepository.findByCallbackStatusAndRegisteredFrom(kaNoticeName, channelId);
    }

    @Override
    public void reloadKAConfiguration() {
        clfCenter.reloadKASetting("");
    }

    @Override
    public List<ChannelApplyInfoStrategy> findChannelApplyInfoStrategyByChannelId(Long channelId) {
        return channelApplyInfoStrategyRepository.findByChannelId(channelId);
    }

    @Override
    public void saveChannelApplyInfoStrategy(ChannelApplyInfoStrategy channelApplyInfoStrategy) {
        channelApplyInfoStrategyRepository.saveAndFlush(channelApplyInfoStrategy);
    }

    @Override
    public List<ClfChannelConfiguration> findAll() {
        Iterable<ClfChannelConfiguration> all = clfChannelConfigurationRepository.findAll();
        List<ClfChannelConfiguration> list = new ArrayList<>();
        if(all != null){
           all.forEach(e->list.add(e));
        }
        return list;
    }


    @Override
    public List<CallbackConfiguration> findCallbackConfigurationByChannelId(Long channelId) {
        return callbackConfigurationRepository.findByChannelId(channelId);

    }
}
