package cn.quantgroup.cashloanflowboss.spi.clf.entity;

import cn.quantgroup.cashloanflowboss.spi.clf.model.CallbackRouter;
import lombok.*;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Created by liqing on 2017/5/5 0005.
 */
@Setter
@Getter
@Entity
@Table(name = "callback_configuration",catalog = "cash_loan_flow")
public class ClfCallbackConfiguration implements Serializable {
    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "channel_id")
    private Long channelId;

    @Column(name = "is_loan_makeup")
    private Boolean isLoanMakeup;

    @Column(name = "is_repay_makeup")
    private Boolean isRepayMakeup;

    @Column(name = "loan_makeup_strategy")
    private String loanMakeupStrategy;

    @Column(name = "repay_makeup_strategy")
    private String repayMakeupStrategy;

    @Column(name = "is_active")
    private Boolean isActive;

    @Column(name = "only_new_user")
    private Boolean onlyNewUser;

    @Column(name = "callback_service_name")
    private String callbackServiceName;

    @Column(name = "callback_no_push_progress")
    private String callbackNoPushProgress;

    @Column(name = "pre_progress")
    private String preProgress;

    @Column(name = "retry_max_times")
    private Long retryMaxTimes;

    @Enumerated(EnumType.ORDINAL)
    @Column(name = "callback_router")
    private CallbackRouter callbackRouter;


}
