package cn.quantgroup.cashloanflowboss.core.asyncer;

import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

import java.util.concurrent.Executor;

/**
 * function:
 * date: 2019/12/6
 *
 * @author: suntao
 */
@Component
public class MyAsyncExecutor {

    @Bean(name = "commonAsyncExecutor")
    public Executor commonAsyncExecutor() {
        return generateThreadPoolTaskExecutor(10, 30, 100, true, 30, true, "commonAsyncExecutor-");
    }


    /**
     * 生成线程池
     * @param corePoolSize
     * @param maxPoolSize
     * @param queueCapacity
     * @param waitForCompleteOnShutdown
     * @param prefix
     * @return
     */
    private ThreadPoolTaskExecutor generateThreadPoolTaskExecutor(int corePoolSize, int maxPoolSize, int queueCapacity,
                                                                  boolean waitForCompleteOnShutdown, int keepAliveSeconds,
                                                                  boolean allowCoreThreadTimeOut, String prefix) {
        ThreadPoolTaskExecutor executor  = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(corePoolSize);
        executor.setMaxPoolSize(maxPoolSize);
        executor.setQueueCapacity(queueCapacity);
        executor.setKeepAliveSeconds(keepAliveSeconds);
        executor.setAllowCoreThreadTimeOut(allowCoreThreadTimeOut);
        executor.setWaitForTasksToCompleteOnShutdown(waitForCompleteOnShutdown);
        executor.setThreadNamePrefix(prefix);
        executor.initialize();
        return executor ;
    }
}
