package cn.quantgroup.cashloanflowboss.api.user.controller;

import cn.quantgroup.cashloanflowboss.api.user.entity.User;
import cn.quantgroup.cashloanflowboss.api.user.model.Pagination;
import cn.quantgroup.cashloanflowboss.api.user.model.RegisterUserFormModel;
import cn.quantgroup.cashloanflowboss.api.user.service.UserService;
import cn.quantgroup.cashloanflowboss.component.security.Power;
import cn.quantgroup.cashloanflowboss.component.security.annotiation.Security;
import cn.quantgroup.cashloanflowboss.component.validator.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * Created by WeiWei on 2019/7/22.
 */
@RestController
@RequestMapping("user")
public class UserController {

    @Autowired
    private UserService userService;

    /**
     * 注册用户
     *
     * @param registerUserFormModel
     * @return
     */
    @PostMapping()
    public Boolean createUser(@RequestBody @Valid RegisterUserFormModel registerUserFormModel) {
        return this.userService.createUser(registerUserFormModel.getUsername(), registerUserFormModel.getPassword());
    }

    /**
     * 获取用户列表（分页）
     *
     * @return
     */
    @GetMapping("/list")
    public Page<User> queryUsers(@RequestParam @Valid Pagination pagination) {
        return this.userService.getUsers(pagination.getPageNumber(), pagination.getPageSize());
    }

    /**
     * 启用用户
     *
     * @param id 用户ID
     * @return
     */
    @PutMapping("/enable")
    public Boolean enableUser(@RequestParam @Valid @NotEmpty(message = "无效的用户ID") String id) {
        return this.userService.enableUser(id);
    }

    /**
     * 禁用用户
     *
     * @param id 用户ID
     * @return
     */
    @PutMapping("/disable")
    public Boolean disableUser(@RequestParam @Valid @NotEmpty(message = "无效的用户ID") String id) {
        return this.userService.disableUser(id);
    }

    /**
     * 移除用户
     *
     * @param id 用户ID
     * @return
     */
    @DeleteMapping()
    public Boolean removeUser(@RequestParam @Valid @NotEmpty(message = "无效的用户ID") String id) {
        return this.userService.removeUser(id);
    }

}
