package cn.quantgroup.cashloanflowboss.core.aspect;
import java.util.Date;

import cn.quantgroup.cashloanflowboss.api.optlog.entity.OptHistoryLog;
import cn.quantgroup.cashloanflowboss.api.optlog.model.OptEnumName;
import cn.quantgroup.cashloanflowboss.api.optlog.service.OptHistoryLogServiceImpl;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.annotation.opt.OperationAnno;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * function:
 * date: 2019/9/23
 *
 * @author: suntao
 */
@Slf4j
@Component
@Aspect
public class OperationAspect {

    @Autowired
    private CLFCenterService clfCenterService;
    @Autowired
    private OptHistoryLogServiceImpl optHistoryLogService;

    @Pointcut("@annotation(cn.quantgroup.cashloanflowboss.core.annotation.opt.OperationAnno)")
    private void operationAnno() {}



    /**
     * @param pjp
     * @return
     * @throws
     */
    @Around("operationAnno()")
    private Object operationAnnoAndSave(ProceedingJoinPoint pjp) throws Throwable {
        MethodSignature methodSignature = (MethodSignature) pjp.getSignature();
        Method method = methodSignature.getMethod();
        OperationAnno annotation = method.getAnnotation(OperationAnno.class);
        Object[] args = pjp.getArgs();

        OptEnumName opt = annotation.opt();
        String succSPEL = annotation.succSPEL();
        String optDetailSPEL = annotation.optDetailSPEL();
        String channelOrderNumber = "";


        if (StringUtils.isNotBlank(annotation.channelNo())) {
            String keySPEL = annotation.channelNo();
            try {
                if (keySPEL.startsWith("#this")) {//判断是否是spel表达式
                    Expression expression = new SpelExpressionParser().parseExpression(keySPEL);
                    String value = expression.getValue(args, String.class);
                    channelOrderNumber = value;
                } else {
                    log.warn("[operationAnnoAnnSave]channelOrderNumber获取失败");
                }
            } catch (ExpressionException e) {
                log.error("[operationAnnoAnnSave]key表达式“" + keySPEL + "”错误：{}", e);
                throw e;
            }
        }
        OptHistoryLog optHistoryLog = new OptHistoryLog();
        if (StringUtils.isNotEmpty(channelOrderNumber)) {
            ClfOrderMapping orderMapping = clfCenterService.findOrderMappingByChannelOrderNo(channelOrderNumber);
            if (orderMapping != null) {
                // do some
                optHistoryLog.setChannelOrderNumber(channelOrderNumber);
                optHistoryLog.setCreditNumber(orderMapping.getApplyNo());
                optHistoryLog.setLoanId(orderMapping.getLoanId());
                optHistoryLog.setChannelId(orderMapping.getRegisteredFrom());
                optHistoryLog.setOptEnumName(opt);
                optHistoryLog.setOptName(opt.getDesc());
                optHistoryLog.setOptUser(Application.getPrincipal().getUserInfo().getNickname());
                optHistoryLog.setCreateTime(new Date());
            } else {
                log.warn("[operationAnnoAnnSave]orderMapping is null, channelOrderNumber={}" , channelOrderNumber );
                return pjp.proceed();
            }
        } else {
            log.warn("[operationAnnoAnnSave]channelOrderNumber is empty, channelOrderNumber={}" , channelOrderNumber );
            return pjp.proceed();
        }
        Object proceed = pjp.proceed();

        if (StringUtils.isNotEmpty(succSPEL)) {
            try {
                if (succSPEL.startsWith("#this")) {//判断是否是spel表达式
                    Expression expression = new SpelExpressionParser().parseExpression(succSPEL);
                    Boolean isSuccess = expression.getValue(proceed, Boolean.class);
                    optHistoryLog.setOptResult(isSuccess);
                } else {
                    log.warn("[operationAnnoAnnSave]optResult获取失败");
                }
            } catch (ExpressionException e) {
                log.error("[operationAnnoAnnSave]key表达式“" + succSPEL + "”错误：{}", e);
                throw e;
            }
        }

        if (StringUtils.isNotEmpty(optDetailSPEL)) {
            try {
                if (optDetailSPEL.startsWith("#this")) {//判断是否是spel表达式
                    Expression expression = new SpelExpressionParser().parseExpression(optDetailSPEL);
                    String optDetail = expression.getValue(proceed, String.class);
                    optHistoryLog.setOptLogDetail(optDetail);
                } else {
                    log.warn("[operationAnnoAnnSave]optDetail获取失败");
                }
            } catch (ExpressionException e) {
                log.error("[operationAnnoAnnSave]key表达式“" + optDetailSPEL + "”错误：{}", e);
                throw e;
            }
        }

        optHistoryLogService.save(optHistoryLog);

        return proceed;
    }
}
