package cn.quantgroup.cashloanflowboss.spi.xyqb.repository;


import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaAccount;
import cn.quantgroup.cashloanflowboss.spi.xyqb.source.XYQBDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by QuantGroup on 2018/3/21.
 */
@XYQBDataSource
@Repository
public interface IQuotaAccountRepository extends JpaRepository<QuotaAccount, Long> {

    @Query(value = "select * from quota_account where uuid = ?1 and product_id=?2 and is_active=1", nativeQuery = true)
    QuotaAccount findByUuidAndProductId(String uuid, Long productId);


    /**
     * 根据用户ID和产品ID查询最新一条账户信息
     *
     * @param userId
     * @param productId
     * @return
     */
    @Query(value = "select * from quota_account where user_id = ?1 and product_id=?2 order by id desc limit 1", nativeQuery = true)
    QuotaAccount findLatestAccount(Long userId, Long productId);

    /**
     * 根据用户ID和产品ID查询可用状态账户信息
     *
     * @param userId
     * @param productId
     * @return
     */
    @Query(value = "select * from quota_account where user_id = ?1 and product_id=?2 and is_active=1", nativeQuery = true)
    QuotaAccount findActiveAccount(Long userId, Long productId);


    /**
     * 根据用户ID查询可用状态账户信息
     *
     * @param userId
     * @return
     */
    @Query(value = "select * from quota_account where user_id = ?1 and is_active=1 order by id desc limit 1", nativeQuery = true)
    QuotaAccount findActiveAccountByUserId(Long userId);


    /**
     * 查询用户历史订单
     *
     * @param userId
     * @return
     */
    @Query(value = "SELECT l.id,l.user_id,l.progress,l.is_active,m.funding_corp_id,m.contract_loan_amount,m.contract_term,m.transaction_status,m.loan_paid_at,m.created_at,l.created_from FROM `loan_application_history` l JOIN `loan_application_manifest_history` m ON l.id = m.`loan_application_history_id` " +
            "WHERE l.`user_id` = ?1 AND l.`business_type` = 0",
            nativeQuery = true)
    List<Object[]> findLoanOrder(Long userId);

    @Query(value = "SELECT l.id,l.user_id,l.progress,l.is_active,m.funding_corp_id,m.contract_loan_amount,m.contract_term,m.transaction_status,m.loan_paid_at,m.created_at,l.created_from FROM `loan_application_history` l JOIN `loan_application_manifest_history` m ON l.id = m.`loan_application_history_id` " +
            "JOIN loan_account_ext la ON la.`loan_id` = l.`id` " +
            "WHERE l.`user_id` = ?1 AND l.`business_type` = 0 AND la.`product_id`= ?2", nativeQuery = true)
    List<Object[]> findLoanOrderByProduct(Long userId, Long productId);

    @Query(value = "SELECT l.id,l.user_id,l.progress,l.is_active,m.funding_corp_id,m.contract_loan_amount,m.contract_term,m.transaction_status,m.loan_paid_at,m.created_at,l.created_from FROM `loan_application_history` l JOIN `loan_application_manifest_history` m ON l.id = m.`loan_application_history_id` " +
            "LEFT JOIN loan_submit_info s ON s.`loan_id` = l.`id` " +
            "WHERE l.`user_id` = ?1 AND l.`business_type` = 0 AND (l.created_from = ?2 OR s.`channel_id` = ?2)", nativeQuery = true)
    List<Object[]> findLoanOrderByChannel(Long userId, Long channelId);


    @Query(value = "SELECT a.* FROM `quota_account` a LEFT JOIN `loan_account_ext` l ON a.`id` = l.`account_id` WHERE l.`loan_id` = ?1 LIMIT 1", nativeQuery = true)
    QuotaAccount findByLoanId(Long loanId);


    @Modifying
    @Query(value = "update quota_account set is_active = 0 ,remark = ?2 WHERE id = ?1", nativeQuery = true)
    int close(Long accountId, String remark);


    @Modifying
    @Query(value = "update quota_account set is_active = 1 WHERE id = ?1 and is_active=0", nativeQuery = true)
    int activeAccount(Long accountId);


    @Query(value = "select q.* from quota_account q LEFT JOIN quota_account_log l on q.id = l.account_id where l.biz_type = 1 and l.biz_id = ?1 ",
    nativeQuery = true)
    QuotaAccount findByApplyId(String applyId);
}
