package cn.quantgroup.cashloanflowboss.api.oneclickdata.service;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.RepaymentPlan;
import com.alibaba.fastjson.JSONObject;

/**
 * Created by shang on 2019/12/5.
 */
public interface RepaymentPlatService {
    /**
     * 是否有未还款计划
     **/
    RepaymentPlan whetherHaveRepayment0rdersList(OneClickData oneClickData);
    /**
     * 获取还款计划表
     **/
    JSONObject getRepaymentOrdersList(String loanID, String token,String repaymentToken,OneClickData oneClickData);
    /**
     * 支付中心token获取
     **/
    String getRepaymentToken(String loanID,String token);
    /**
     * 获取卡信息
     *
     * */
    JSONObject getCardListInfo(String repaymentToken,OneClickData oneClickData);

    /**
     * 获取金额信息
     *
     * * */
    JSONObject getPayMoneyInfo(String repaymentToken);

    /**
     * 支付确认页面
     * */
    JSONObject paymentConfirmation(OneClickData oneClickData,String repaymentToken);

    /**
     * 银行卡认证信息
     * */
    JSONObject bankCardAuthenticationInformation(String repaymentToken);

    /**
     * 发送验证码
     * */
    JSONObject sendSMS(String repaymentToken);

    /**
     * 确认支付
     * */
    JSONObject confirmPayment(String repaymentToken);

    /**
     * 绑卡操作
     * */
    JSONObject bingCard(String repaymentToken, String cardId ,String preservePhoneNo,String payApproach);

    /**
     * 绑卡操作-获取短信验证码
     * */
    JSONObject bingCardSms(String repaymentToken,String cardId,String preservePhoneNo,String payApproach);

    /**
     * 绑卡操作-确认绑卡
     * */
    JSONObject bingCardSmsConfirm(String repaymentToken, String cardId,String payApproach);


}
