package cn.quantgroup.cashloanflowboss.core.aspect;
import java.util.Date;

import cn.quantgroup.cashloanflowboss.api.optlog.entity.OptHistoryLog;
import cn.quantgroup.cashloanflowboss.api.optlog.model.OptEnumName;
import cn.quantgroup.cashloanflowboss.api.optlog.service.OptHistoryLogServiceImpl;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.annotation.opt.OperationAnno;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * function:
 * date: 2019/9/23
 *
 * @author: suntao
 */
@Slf4j
@Component
@Aspect
public class OperationAspect {

    @Autowired
    private CLFCenterService clfCenterService;
    @Autowired
    private OptHistoryLogServiceImpl optHistoryLogService;

    @Pointcut("@annotation(cn.quantgroup.cashloanflowboss.core.annotation.opt.OperationAnno)")
    private void operationAnno() {}



    /**
     * @param pjp
     * @return
     * @throws
     */
    @Around("operationAnno()")
    private Object operationAnnoAndSave(ProceedingJoinPoint pjp) throws Throwable {

        try {
            MethodSignature methodSignature = (MethodSignature) pjp.getSignature();
            Method method = methodSignature.getMethod();
            OperationAnno annotation = method.getAnnotation(OperationAnno.class);
            Object[] args = pjp.getArgs();

            OptEnumName opt = annotation.opt();
            String succSPEL = annotation.succSPEL();
            String optDetailSPEL = annotation.optDetailSPEL();
            String channelOrderNumber = "";


            if (StringUtils.isNotBlank(annotation.channelNo())) {
                String keySPEL = annotation.channelNo();
                try {
                    if (keySPEL.startsWith("#this")) {//判断是否是spel表达式
                        Expression expression = new SpelExpressionParser().parseExpression(keySPEL);
                        String value = expression.getValue(args, String.class);
                        channelOrderNumber = value;
                    } else {
                        log.warn("[operationAnnoAnnSave]channelOrderNumber获取失败");
                    }
                } catch (ExpressionException e) {
                    log.error("[operationAnnoAnnSave]key表达式“" + keySPEL + "”错误：{}", e);
                    throw e;
                }
            }
            OptHistoryLog optHistoryLog = new OptHistoryLog();
            if (StringUtils.isNotEmpty(channelOrderNumber)) {
                ClfOrderMapping orderMapping = clfCenterService.findOrderMappingByChannelOrderNo(channelOrderNumber);
                if (orderMapping != null) {
                    // do some
                    optHistoryLog.setChannelOrderNumber(channelOrderNumber);
                    optHistoryLog.setCreditNumber(orderMapping.getApplyNo());
                    optHistoryLog.setLoanId(orderMapping.getLoanId());
                    optHistoryLog.setChannelId(orderMapping.getRegisteredFrom());
                    optHistoryLog.setOptEnumName(opt);
                    optHistoryLog.setOptName(opt.getDesc());
                    optHistoryLog.setOptUser(Application.getPrincipal().getUserInfo().getNickname() + "_" + Application.getPrincipal().getUserInfo().getUsername());
                    optHistoryLog.setCreateTime(new Date());
                } else {
                    log.warn("[operationAnnoAnnSave]orderMapping is null, channelOrderNumber={}" , channelOrderNumber );
                    return pjp.proceed();
                }
            } else {
                log.warn("[operationAnnoAnnSave]channelOrderNumber is empty, channelOrderNumber={}" , channelOrderNumber );
                return pjp.proceed();
            }

            // 是否成功SPEL 表达式解析
            Expression expressionsuccSPEL = null;
            if (StringUtils.isNotEmpty(succSPEL)) {
                try {
                    if (succSPEL.startsWith("#this")) {//判断是否是spel表达式
                        expressionsuccSPEL = new SpelExpressionParser().parseExpression(succSPEL);
                    } else {
                        log.warn("[operationAnnoAnnSave]optResult获取失败");
                    }
                } catch (ExpressionException e) {
                    log.error("[operationAnnoAnnSave]key表达式“" + succSPEL + "”错误：{}", e);
                    throw e;
                }
            }

            Expression expressionMsgSPEL = null;
            if (StringUtils.isNotEmpty(optDetailSPEL)) {
                try {
                    if (optDetailSPEL.startsWith("#this")) {//判断是否是spel表达式
                        expressionMsgSPEL = new SpelExpressionParser().parseExpression(optDetailSPEL);
                    } else {
                        log.warn("[operationAnnoAnnSave]optDetail获取失败");
                    }
                } catch (ExpressionException e) {
                    log.error("[operationAnnoAnnSave]key表达式“" + optDetailSPEL + "”错误：{}", e);
                    throw e;
                }
            }

            if (StringUtils.isNotEmpty(channelOrderNumber)) {
                // 判断是否  已经请求成功过
                OptHistoryLog optHistoryLogSuccess = optHistoryLogService.findByChannelOrderNumberAndOptNameAndSuccess(channelOrderNumber, opt);
                if (optHistoryLogSuccess != null) {
                    Class returnType = ((MethodSignature) pjp.getSignature()).getReturnType();
                    if (returnType != null) {
                        Object ret = returnType.newInstance();
                        if (expressionsuccSPEL != null) {
                            expressionsuccSPEL.setValue(ret, true);
                        }
                        if (expressionMsgSPEL != null) {
                            expressionMsgSPEL.setValue(ret, "该操作已经操作成功，无须重复操作！");
                        }
                        // 直接返回 重复操作结果
                        log.info("[operationAnnoAnnSave]该操作已经操作成功,无须重复操作,切面返回");
                        return ret;
                    }

                }
            }

            // 代理执行方法
            Object proceed = pjp.proceed();

            // 获取方法返回 是否成功
            if (expressionsuccSPEL != null) {
                optHistoryLog.setOptResult(expressionsuccSPEL.getValue(proceed, Boolean.class));
            }

            // 获取方法详细信息
            if (expressionMsgSPEL != null) {
                optHistoryLog.setOptLogDetail(expressionMsgSPEL.getValue(proceed, String.class));
            }

            optHistoryLogService.save(optHistoryLog);
            return proceed;
        } catch (Throwable throwable) {
            log.error("[operationAnnoAnnSave]异常，直接跳过，e={}", ExceptionUtils.getStackTrace(throwable));
            return pjp.proceed();
        }
    }
}
