package cn.quantgroup.cashloanflowboss.core.base;

import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.core.dictionary.Status;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * 请求返回数据结构实体类
 * <p>
 * Created by WeiWei on 2017/5/2.
 */
@Data
public class Result<T> {

    /**
     * 状态码
     */
    private Integer code;

    /**
     * 描述信息
     */
    private String message;

    /**
     * 返回结果
     */
    private T data;

    public Result() {}

    public Result(Status status) {
        this(status, null);
    }

    public Result(Status status, T data) {
        this(status, data, null);
    }

    public Result(Status status, T data, String message) {

        if (Objects.nonNull(status)) {
            this.code = status.getCode();
            this.message = Objects.isNull(message) ? status.getMessage() : message;
            this.data = data;
        }

    }


    @SuppressWarnings("unchecked")
    public static <T> Result<T> buildSuccess(T data) {
        return new Result(ApplicationStatus.SUCCESS, data);
    }

    @SuppressWarnings("unchecked")
    public static <T> Result<T> buildSuccess(T data, String message) {
        return new Result(ApplicationStatus.SUCCESS, data, message);
    }

    @SuppressWarnings("unchecked")
    public static <T> Result<T> buildFial(T data) {
        return new Result(ApplicationStatus.FAILURE, data);
    }

    @SuppressWarnings("unchecked")
    public static <T> Result<T> buildFial(String message) {
        return new Result(ApplicationStatus.FAILURE, null, message);
    }

    @SuppressWarnings("unchecked")
    public static <T> Result<T> buildFial() {
        return new Result(ApplicationStatus.FAILURE, null, null);
    }

    @SuppressWarnings("unchecked")
    public static <T> Result<T> buildFial(ApplicationStatus applicationStatus) {
        return new Result(applicationStatus, null, null);
    }

    @SuppressWarnings("unchecked")
    public static <T> Result<T> buildFial(T data, String message) {
        return new Result(ApplicationStatus.FAILURE, data, message);
    }

}
