package cn.quantgroup.cashloanflowboss.api.optlog.controller;

import cn.quantgroup.cashloanflowboss.api.optlog.entity.OptHistoryLog;
import cn.quantgroup.cashloanflowboss.api.optlog.service.OptHistoryLogService;
import cn.quantgroup.cashloanflowboss.api.order.model.OrderBaseModel;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * function:
 * date: 2019/9/4
 *
 * @author: suntao
 */
@RestController
@RequestMapping("/opt")
public class OperateController {

    @Autowired
    private OptHistoryLogService optHistoryLogService;


    @GetMapping("/history/log/all")
    public Result findAllOptHistoryLog(OrderBaseModel orderBaseModel) {
        final List<OptHistoryLog> allOptHistoryLog = optHistoryLogService.getAllOptHistoryLog(orderBaseModel);
        if (CollectionUtils.isNotEmpty(allOptHistoryLog)) {
            return Result.buildSuccess(allOptHistoryLog);
        } else {
            return Result.buildSuccess("无数据");
        }
    }
}
