package cn.quantgroup.cashloanflowboss.spi.paycenter.model;

import lombok.Getter;

/**
 * Created by FrankChow on 16/3/8.
 */
@Getter
public enum CardType {
  //银行卡类型
  UNKNOW("未知类型", "UNKNOWN"),
  CRIDIT_CARD("信用卡", "CREDIT"),
  DEBIT_CARD("借记卡", "DEBIT"),
  PRE_PAID_CARD("预付费卡", "PREPAID"),
  SEMI_CREDIT_CARD("准贷记卡", "SEMI_CREDIT"),
  OTHER("其它", "OTHER");

  private String desc;

  private String name;

  CardType(String desc, String name) {
    this.desc = desc;
    this.name = name;
  }

  public static CardType fromCardType(String name) {
    CardType[] types = CardType.values();
    for (CardType type : types) {
      if (type.getName().equals(name)) {
        return type;
      }
    }
    return UNKNOW;
  }

}
