package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;


import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.ResposeResultEnum;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.spi.user.service.XyqbUserService;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.FinanceProduct;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.QuotaCredit;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.IFinanceProductRepository;
import cn.quantgroup.cashloanflowboss.spi.xyqb.repository.QuotaCreditRepository;
import cn.quantgroup.cashloanflowboss.utils.ChineseIDCardNumberGenerator;
import cn.quantgroup.cashloanflowboss.utils.CommonConstant;
import cn.quantgroup.cashloanflowboss.utils.GetAuthorization;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import cn.quantgroup.user.retbean.XUser;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.testng.Assert;
import org.testng.annotations.Test;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by shang on 2019/12/4.
 */
@Slf4j
@Service
public class PhoneInfoServiceImpl implements PhoneInfoService {
    private String token = "";

    @Value("${NAMESPACE}")
    private String nameSpace;
    @Value("${passportapi.http}")
    private String passportapiHttp;
    @Value("${api.http.net}")
    private String apiHttp;
    @Value("${scapi.http.net}")
    private String scapiHttp;
    @Value("${mapi.http.net}")
    private String mapiHttp;
    @Value("${sc.http.net}")
    private String scHttp;
    @Autowired
    private QuotaCreditRepository quotaCreditRepository;
    @Autowired
    private IFinanceProductRepository iFinanceProductRepository;
    @Autowired
    private XyqbUserService xyqbUserService;

    public String getToken(String phone,String createdFrom) throws Exception {

        String url = passportapiHttp + "/user/login/fastV1";

        Map<String, String> paras = new HashMap<String, String>();
        paras.put("channelId", "1");
        paras.put("createdFrom", createdFrom);
        paras.put("key", "xyqb");
        paras.put("btRegisterChannelId", "");
        paras.put("dimension", "");
        paras.put("click_id", "");
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        String verification = GetAuthorization.getAuthorizationEncryption(phone);
        header.put("Authorization", verification);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        JSONObject resultDate = (JSONObject) result.get("data");
        String code=result.get("code").toString().trim();
        String businessCode=result.get("businessCode").toString().trim();
        if(ResposeResultEnum.BUSINESSCODE.getDesc().equals(code) && ResposeResultEnum.BUSINESSCODE.getDesc().equals(businessCode)){
            token = resultDate.get("token").toString().trim();

        }else{
            log.info("获取token失败,返回失败原因：{}",result);

        }
        return token;
    }



    /**
     * 同步session到xyqb
     * 返回空
     */
    @Test(description = "同步session到xyqb")
    @Override
    public JSONObject sySessionToXYQB(String phone,String createdFrom)  throws Exception{
         token=getToken(phone,createdFrom);
        String url = apiHttp + "/ex/login/receive_token?token=" + token;

        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/json");
        JSONObject reslut = HttpRequest.doGetReturnResponseJson(url, null, header);
        log.info("获取返回结果,{}", reslut);
        Assert.assertEquals(reslut.get("statusCode").toString().trim(), "0");
        return reslut;
    }

    @Override
    public XUser selectUserID(String phone) {
        return xyqbUserService.findUserByPhoneNo(phone);
    }


    /**
     * 实名认证
     */
    @Override
    public JSONObject authIdNo(String phone,String createdFrom) throws Exception{
        token=getToken(phone,createdFrom);
        String url = apiHttp + "/loan/auth/id_no";
        Map<String, String> paras = new HashMap<String, String>();
        paras.put("name", "刘志");
        paras.put("idNo", ChineseIDCardNumberGenerator.generate());
        paras.put("idType", "0");
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", token);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        log.info("获取返回结果={}", result);
        return result;

    }

    @Override
    public JSONObject creditSession(String productId,String phone,String createdFrom) throws Exception {
        String url = apiHttp + "/v3/credit/apply?productId=" + productId;
        Map<String, String> header = new HashMap<String, String>();
        token=getToken(phone,createdFrom);
        header.put("x-auth-token", token);
        JSONObject result = HttpRequest.doGetReturnResponseJson(url, null, header);
        log.info("获取返回结果={}", result);
        Assert.assertEquals(result.get("code").toString().trim(), "0000");
        return result;
    }

    @Override
    public JSONObject authBasic2(String token) throws Exception {
        String url = scapiHttp + "/auth/basic2/infos";
        Map<String, String> paras = new HashMap<String, String>();
        paras.put("firstName", "任明星");
        paras.put("firstMobile", "13500000002");
        paras.put("firstRelation", "2");
        paras.put("secondName", "陈玉秋");
        paras.put("secondMobile", "13500000001");
        paras.put("secondRelation", "2");
        paras.put("address", "互联网金融中心");
        paras.put("city", "市辖区");
        paras.put("cityCode", "110100");
        paras.put("province", "北京市");
        paras.put("provinceCode", "110000");
        paras.put("district", "怀柔区");
        paras.put("districtCode", "110116");
        paras.put("vocation", "3");
        paras.put("salary", "3");
        paras.put("education", "3");
        paras.put("email", "12345678@qq.com");
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", token);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        log.info("获取返回结果={}", result);
        Assert.assertEquals(result.get("code").toString().trim(), "0000");
        return result;
    }

    @Override
    public String authOcrUrl() throws Exception {
        String url = mapiHttp + "/sc/auth/ocr/url";
        Map<String, String> paras = new HashMap<String, String>();
        String returnUrl = scHttp + "/auth-page";
        paras.put("returnUrl", returnUrl);
        paras.put("registerFrom", "1");
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", token);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        JSONObject resultData = (JSONObject) result.get("data");
        String  ocrToken = resultData.toString().trim().split("\\?")[1].split("&")[0].split("=")[1].toString().trim();
        log.info("获取返回结果={}", result);
        Assert.assertEquals(result.get("businessCode").toString().trim(), "0000");
        return ocrToken;
    }

    @Override
    public JSONObject ocrAtuhUp(String ocrToken) throws Exception {
        String url = "http://operator.liangkebang.com/auth-center/h5/api/ocr/auth.json";
        Map<String, String> paras = new HashMap<String, String>();
        String img_str = CommonConstant.CERTIMAG_UP;
        paras.put("img_str", img_str);
        paras.put("card_type", "0");
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", ocrToken);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        log.info("获取返回结果={}", result);
        Assert.assertEquals(result.get("business_code").toString().trim(), "0");
        return result;
    }

    @Override
    public JSONObject ocrAtuhDown(String ocrToken) throws Exception {

        String url = "http://operator.liangkebang.com/auth-center/h5/api/ocr/auth.json";
        Map<String, String> paras = new HashMap<String, String>();
        String img_str = CommonConstant.CERTIMAG_DWON;
        paras.put("img_str", img_str);
        paras.put("card_type", "1");
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", ocrToken);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        log.info("获取返回结果={}" , result);
        Assert.assertEquals(result.get("business_code").toString().trim(), "0");
        return result;
    }

    @Override
    public JSONObject ocrSubmit(String ocrToken) throws Exception {

        String url = "http://operator.liangkebang.com/auth-center/h5/api/ocr/submit.json";
        Map<String, String> paras = new HashMap<String, String>();
        String img_str = CommonConstant.CERTIMAG_UP;
        paras.put("real_name", CommonConstant.REAL_NAME);
        paras.put("id_card_no", CommonConstant.ID_CARD_NO);
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", ocrToken);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        log.info("获取返回结果={}" , result);
        Assert.assertEquals(result.get("business_code").toString().trim(), "0");
        return result;
    }

    @Override
    public void getSpiderCenter() {
  // 无用
    }

    @Override
    public void spiderC()  {
// 数据库中插入数据
    }

    @Override
    public JSONObject submitAuth(String token) throws Exception {
        String url = scapiHttp + "/auth/submit";
        Map<String, String> paras = new HashMap<String, String>();
        paras.put("purpose", "-1");
        paras.put("dimension", "");
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", token);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        Assert.assertEquals(result.get("businessCode").toString().trim(), "0000");
        return result;
    }

    @Override
    public QuotaCredit selectUserAuditRecords(Long qgUserId,Long channel) {
      return   quotaCreditRepository.findByUserIdAndChannelAndIsActiveAndCreditStatus(qgUserId, channel);
    }

    @Override
    public QuotaCredit selectUserAuditRecordsNotCreditStatus(Long qgUserId,Long channel) {
        return   quotaCreditRepository.findByUserIdAndChannelAndIsActive(qgUserId, channel);
    }

    @Override
    public QuotaCredit selectUserAuditRecords(String applyNo) {
        return quotaCreditRepository.findByorderNoAndIsActive(applyNo);
    }

    @Override
    public JSONObject spiderFinishNotic(String quotaRecordOrderNo,String  channel) {
        String url = apiHttp + "/ex/spider_center/spider_finish";
        Map<String, String> paras = new HashMap<String, String>();
        paras.put("orderNo", quotaRecordOrderNo);
        paras.put("extData", "{\"channelId\":\"" + channel + "\"}");
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", token);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        Assert.assertEquals(result.get("statusCode").toString().trim(), "200");
        return result;
    }

    @Override
    public JSONObject spiderReportFinishNotic(String quotaRecordOrderNo) {
        String url = apiHttp + "/ex/spider_center/report_finish";
        Map<String, String> paras = new HashMap<String, String>();
        paras.put("orderNo", quotaRecordOrderNo);
        Map<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("x-auth-token", token);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, paras, header);
        Assert.assertEquals(result.get("statusCode").toString().trim(), "200");
        return result;
    }

    @Override
    public void updat800QouteProductType() {

    }

    @Override
    public List<FinanceProduct> getFinanceProduct(Long fundCorpId){
       return  iFinanceProductRepository.findByFundCorpId(fundCorpId);
    }


    public static void main(String[] args) throws Exception {
        PhoneInfoServiceImpl phon = new PhoneInfoServiceImpl();
        phon.nameSpace = "arch";
        phon.passportapiHttp = "http://passportapi-arch.liangkebang.net";


        log.info("打印,token={}", phon.getToken("13067912192",""));
//        phon.sySessionToXYQB();
//          String a="222";
//        log.info("[getParamsFromEOS],result={}",a);

    }
}
