package cn.quantgroup.cashloanflowboss.spi.xyqb.entity;

import cn.quantgroup.cashloanflowboss.utils.CommonConstant;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * Created by shang on 2019/12/18.
 * 配额授信
 */
@Data
@Entity
@Table(name = "quota_credit")
public class QuotaCredit {
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 用户ID
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 预留字段, 客户ID
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 渠道
     */
    @Column(name = "channel")
    private Long channel;

    /**
     * 和授信中心关联字段
     */
    @Column(name = "order_no")
    private String orderNo;

    /**
     * 授信状态
     *
     */
    @Column(name = "credit_status")
    private int creditStatus;

    /**
     * 授信信息来源
     *
     */
    @Column(name = "credit_source")
    private int creditSource;

    /**
     * 产品id,关联产品表
     * KA 渠道来的数据，会提前把这个值传过来，需要存下来之后用
     */
    @Column(name = "product_id")
    private Long productId;

    /**
     * 产品类型;  0:现金分期;1:白条循环;2:现金循环额度
     *
     *
     */
    @Column(name = "product_type")
    private int productType;

    /**
     * 授信状态
     */
    @Column(name = "remark")
    private String remark = "";

    /**
     * 接收到风控回调时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "receive_at")
    private Timestamp receiveAt;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;

    /**
     * 马甲包数据
     */
    @Column(name = "loan_vest_info")
    private String loanVestInfo = "";

    /**
     * app 渠道
     */
    @Column(name = "app_channel")
    private String appChannel = "";

    /**
     * 可用状态
     */
    @Column(name = "is_active")
    private Boolean isActive = true;
    @PrePersist
    public void prePersist() {
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        createdAt = timestamp;
        updatedAt = timestamp;
        receiveAt = CommonConstant.DEFAULT_TIME;
    }

    @PreUpdate
    public void preUpdate() {
        updatedAt = new Timestamp(System.currentTimeMillis());
    }
}
