package cn.quantgroup.cashloanflowboss.spi.clf.service;

import cn.quantgroup.cashloanflowboss.api.order.model.OrderBaseModel;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.*;
import org.springframework.data.domain.Page;

import java.util.List;

/**
 * function:
 * date: 2019/9/16
 *
 * @author: suntao
 */
public interface CLFCenterService {

    List<CallbackFailRecord> findCallbackFailRecordByApplyNo(String applyNo);

    List<CallbackRecord> findCallbackRecordByApplyNo(String applyNo);

    ClfOrderMapping findOrderMappingByChannelOrderNo(String channelOrderNumber);

    List<WithdrawRecord> findWithdrawRecordList(String channelOrderNumber, Long channelId);

    List<ApplyRequestHistory> findApplyRequestHistoryBySpecification(OrderBaseModel orderBaseModel);

    Page<ClfChannelConfiguration> findChannelConfigurationByCriteriaQueryPage(Integer pageNumber, Integer pageSize, Long channelId, String channelName);

    ClfChannelConfiguration findChannelConfigurationByChannelId(Long channelId);

    void saveChannelConfiguration(ClfChannelConfiguration channelConfiguration);

    void saveCallbackConfiguration(ClfCallbackConfiguration clfCallbackConfiguration);

    void saveOrderCall(List<ClfOrderCallBack> clfOrderCallBackList);

    ClfOrderCallBack findOrderCallBackByByCallbackStatusAndChannelId(String name, Long channelId);

    void reloadKAConfiguration();

    List<ChannelApplyInfoStrategy> findChannelApplyInfoStrategyByChannelId(Long channelId);

    void saveChannelApplyInfoStrategy(ChannelApplyInfoStrategy channelApplyInfoStrategy);

    ClfCallbackConfiguration  findCallbackConfigurationByChannelId(Long channelId);


    List<ClfChannelConfiguration> findAll();

    void saveChannelSecurityKey(ChannelSecurityKey securityKey);

    ChannelSecurityKey findChannelSecurityByChannelId(Long channelId);


    List<ClfOrderCallBack> findClfOrderCallBackByChannelId(Long channelId);


}
