package cn.quantgroup.cashloanflowboss.api.order.util;

import cn.quantgroup.cashloanflowboss.api.optlog.entity.OptHistoryLog;
import cn.quantgroup.cashloanflowboss.api.optlog.model.OptEnumName;
import cn.quantgroup.cashloanflowboss.api.order.entity.OrderApprove;
import cn.quantgroup.cashloanflowboss.core.base.Tuple;
import cn.quantgroup.cashloanflowboss.core.tuple.ThreeTuple;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ApplyRequestHistory;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderMapping;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.WithdrawRecord;
import cn.quantgroup.cashloanflowboss.spi.clf.model.KANoticeType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * function:
 * date: 2019/8/8
 *
 * @author: suntao
 */
public class OrderUtil {
    public static final String financeProductsFormat = "[{\"min\":%s,\"max\":%s,\"terms\":[{\"term\":%s,\"fundInfo\":[{\"fundId\":%s,\"rate\":\"0\",\"rateType\":1,\"priority\":\"1\",\"feeType\":\"1\"}]}]}]";

    /**
     *
     * @param kaNoticeType
     * @return 状态英文，状态中文
     */
    public static Tuple<String, String> KaNoticeTypeConvertChnName(KANoticeType kaNoticeType, OrderApprove orderApprove) {

        if (kaNoticeType != null) {
            switch (kaNoticeType.name()) {
                case "CREDIT_SUCC" :
                    // 授信成功 需要 审批
                    return new Tuple("CREDIT_SUCC", "授信成功");
                case "APPROVE_ING" :
                    if (orderApprove == null) {
                        return new Tuple("APPROVE_ING", "授信成功,待审批");
                    } else {
                        return new Tuple("APPROVE_ING", "审批中");
                    }
                case "REJECT" :
                    return new Tuple(kaNoticeType.name(), "审批拒绝");
                case "FUAD_ASSIFN_SUCC" :
                    return new Tuple(kaNoticeType.name(), "审批通过，待提现");
                case "WITHDRAW" :
                    // 提现申请成功 需要放款
                    return new Tuple(kaNoticeType.name(), "申请提现成功");
                case "PAY_ING" :
                    return new Tuple("PAY_ING", "放款中");
                case "FUND_SUCC" :
                    if (orderApprove != null && orderApprove.getFundType() != 0) {
                        // 是存管
                        return new Tuple(kaNoticeType.name(), "放款到存管，待提现");
                    } else {
                        return new Tuple(kaNoticeType.name(), "放款成功");
                    }
                case "FUND_WITHDRAW_SUCC" :
                    return new Tuple(kaNoticeType.name(), "存管提现成功");
                case "FUND_FAIL" :
                    return new Tuple(kaNoticeType.name(), "放款失败");
                case "ALL_REPAID" :
                    return new Tuple(kaNoticeType.name(), "已结清");
                case "CANCEL_LOAN" :
                    return new Tuple(kaNoticeType.name(), "已关单");
                case "CANCEL_AFTER_LOAN" :
                    return new Tuple(kaNoticeType.name(), "存管提现超时或贷后关单");
                default:
                    return new Tuple(kaNoticeType.name(), "未知状态");
            }
        }
        return new Tuple(kaNoticeType.name(), "未知状态");
    }

    /**
     *
     * @param kaNoticeType
     * @return 状态英文，状态中文
     */
    public static Tuple<String, String> KaNoticeTypeNameConvertChnName(String kaNoticeType, OrderApprove orderApprove) {

        if (StringUtils.isNotEmpty(kaNoticeType)) {
            switch (kaNoticeType) {
                case "CREDIT_SUCC" :
                    // 授信成功 需要 审批
                    return new Tuple("CREDIT_SUCC", "授信成功");
                case "APPROVE_ING" :
                    if (orderApprove == null) {
                        return new Tuple("APPROVE_ING", "授信成功");
                    } else {
                        return new Tuple("APPROVE_ING", "审批中");
                    }
                case "REJECT" :
                    return new Tuple(kaNoticeType, "审批拒绝");
                case "FUAD_ASSIFN_SUCC" :
                    return new Tuple(kaNoticeType, "审批通过");
                case "WITHDRAW_APPROVING" :
                    // 等待二次风控审批 审批中
                    return new Tuple(kaNoticeType, "提现（二次）审批中");
                case "WITHDRAW" :
                    // 提现申请成功 需要放款
                    return new Tuple(kaNoticeType, "申请提现成功");
                case "PAY_ING" :
                    return new Tuple("PAY_ING", "放款中");
                case "FUND_WAITING_WITHDRAW" :
                    return new Tuple("FUND_WAITING_WITHDRAW", "放款到存管账户，待二次提现");
                case "FUND_SUCC" :
                    if (orderApprove != null && orderApprove.getFundType() != 0) {
                        // 是存管
                        return new Tuple(kaNoticeType, "放款到存管");
                    } else {
                        return new Tuple(kaNoticeType, "放款成功");
                    }
                case "FUND_WITHDRAW_SUCC" :
                    return new Tuple(kaNoticeType, "存管提现成功");
                case "FUND_FAIL" :
                    return new Tuple(kaNoticeType, "放款失败");
                case "ALL_REPAID" :
                    return new Tuple(kaNoticeType, "已结清");
                case "CANCEL_LOAN" :
                    return new Tuple(kaNoticeType, "已关单");
                case "CANCEL_AFTER_LOAN" :
                    return new Tuple(kaNoticeType, "存管提现超时或贷后关单");
                default:
                    return new Tuple(kaNoticeType, "未知状态");
            }
        }
        return new Tuple(kaNoticeType, "未知状态");
    }

    /**
     * ka 的 进件记录 转换成 操作记录
     * @param applyRequestHistoryList
     * @param orderMapping
     * @return
     */
    public static List<OptHistoryLog> convertApplyRequestHistoryList2OptHistoryLogList(List<ApplyRequestHistory> applyRequestHistoryList, ClfOrderMapping orderMapping) {
        List<OptHistoryLog> optHistoryLogs = new ArrayList<>();
        for (ApplyRequestHistory applyRequestHistory : applyRequestHistoryList) {
            OptHistoryLog optHistoryLog = new OptHistoryLog();
            optHistoryLog.setChannelOrderNumber(applyRequestHistory.getChannelOrderNo());
            optHistoryLog.setCreditNumber(orderMapping.getApplyNo());
            optHistoryLog.setLoanId(orderMapping.getLoanId());
            optHistoryLog.setChannelId(applyRequestHistory.getChannelId());
            optHistoryLog.setOptName(applyRequestHistory.getApplyType().getDesc());
            optHistoryLog.setOptUser(applyRequestHistory.getUserName());
            optHistoryLog.setOptLogDetail(applyRequestHistory.getDescriptionDetail());
            optHistoryLog.setExtData(applyRequestHistory.getExtData());
            optHistoryLog.setOptResult(applyRequestHistory.getIsSuccess());
            optHistoryLog.setCreateTime(applyRequestHistory.getCreatedAt());
            optHistoryLogs.add(optHistoryLog);
        }
        return optHistoryLogs;
    }

    /**
     * ka api 提现转换 opt
     * @param withdrawRecordList
     * @return
     */
    public static List<OptHistoryLog> convertWithdrawRecordList2UserOptHistoryLogList(List<WithdrawRecord> withdrawRecordList) {
        if (CollectionUtils.isEmpty(withdrawRecordList)) {
            return null;
        }
        List<OptHistoryLog> optHistoryLogList = new ArrayList<>();
        for (WithdrawRecord withdrawRecord : withdrawRecordList) {
            OptHistoryLog optHistoryLog = new OptHistoryLog();
            optHistoryLog.setChannelOrderNumber(withdrawRecord.getChannelOrderNo());
            optHistoryLog.setChannelId(withdrawRecord.getChannelId());
            optHistoryLog.setOptName(OptEnumName.WITHDRAW.getDesc());
            optHistoryLog.setOptUser("");
            optHistoryLog.setOptLogDetail(withdrawRecord.getDescriptionDetail());
            optHistoryLog.setExtData("");
            optHistoryLog.setOptResult(withdrawRecord.getIsSuccess());
            optHistoryLog.setCreateTime(withdrawRecord.getCreatedAt());
            optHistoryLogList.add(optHistoryLog);
        }
        return optHistoryLogList;
    }
}
