package cn.quantgroup.cashloanflowboss.spi.xyqb.entity;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;

/**
 * 金融产品
 *
 * @author PoppyWong
 * @since 2019/11/18.
 */
@Entity
@Data
@Table(name = "finance_product")
public class FinanceProduct implements Serializable {

    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 资方id
     */
    @Column(name = "fund_corp_id")
    private Long fundCorpId;

    /**
     * 月利率
     */
    @Column(name = "monthly_interest_rate")
    private BigDecimal monthlyInterestRate;

    /**
     * 还款类型：1：等额本金:0：等额本息
     */
    @Column(name = "repayment_type")
    private Integer repaymentType;

    /**
     * 计息规则
     */
    @Column(name = "repayment_rule")
    private String repaymentRule;

    /**
     * 数据有效性标志位
     */
    @Column(name = "is_active")
    private Integer isActive;

    /**
     * 描述
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "created_at")
    private Timestamp createdAt;

    /**
     * 更新时间
     */
    @Column(name = "updated_at")
    private Timestamp updatedAt;

    /**
     * {1:"0.0001",2:"0.00012",0:"0.00011"}0表示任何其他期
     */
    @Column(name = "service_fee_config")
    private String serviceFeeConfig;

    /**
     * 展示日利率
     */
    @Column(name = "show_day_interest")
    private BigDecimal showDayInterest;

    /**
     * 展示月利率
     */
    @Column(name = "show_month_interest")
    private BigDecimal showMonthInterest;

    /**
     * 展示年利率
     */
    @Column(name = "show_year_interest")
    private BigDecimal showYearInterest;
}
