package cn.quantgroup.cashloanflowboss.spi.xyqb.repository;

import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.FundLending;
import cn.quantgroup.cashloanflowboss.spi.xyqb.source.XYQBDataSource;
import org.hibernate.annotations.SQLUpdate;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.Map;

/**
 * Created by WeiWei on 2019/8/12.
 */
@XYQBDataSource
@Repository
public interface FundLendingRepository extends CrudRepository<FundLending, Integer> {

    /**
     * 更新资方待放款创建时间
     *
     * @param loanId
     * @param time
     * @return
     */
    @Modifying
    @Transactional
    @Query("update FundLending set createTime = ?2 where loanId = ?1")
    boolean updateCreateTime(@Param("loanId") Long loanId, @Param("createTime") Date time);

    /**
     * 查询待放款记录
     *
     * @param fundId
     * @param progress
     * @return
     */
    @Query("select sum(amount) as totalAmount ,count(fundId) as totalCount from FundLending where progress = ?2 and fundId = ?1")
    Map queryLendingRecordCount(@Param("fundId")Integer fundId, @Param("progress")Integer progress);

    FundLending findByLoanId(Long loanId);

}