package cn.quantgroup.cashloanflowboss.api.oneclickdata.service.impl;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.UrlRequestConfig;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.model.*;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.OneClickDataRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.repository.UrlRequestConfigRespository;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.CashWithdrawalService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.LoanOperationService;
import cn.quantgroup.cashloanflowboss.api.oneclickdata.service.PhoneInfoService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.core.dictionary.ApplicationStatus;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfChannelConfiguration;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterServiceImpl;
import cn.quantgroup.cashloanflowboss.spi.paycenter.entity.CardCheckRecordEntity;
import cn.quantgroup.cashloanflowboss.spi.paycenter.model.CardType;
import cn.quantgroup.cashloanflowboss.spi.paycenter.repository.ICardCheckRecordRepository;
import cn.quantgroup.cashloanflowboss.spi.xyqb.entity.LoanApplicationHistory;
import cn.quantgroup.cashloanflowboss.utils.*;
import cn.quantgroup.cashloanflowboss.utils.http.HttpRequest;
import com.alibaba.fastjson.JSONObject;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * Created by shang on 2019/12/18.
 */
@Slf4j
@Service
public class CashWithdrawalServiceImpl implements CashWithdrawalService{
    @Value("${qapi.http.net}")
    private String qapiHttp;
    @Autowired
    private OneClickDataRespository oneClickDataRespository;
    @Autowired
    private CLFCenterServiceImpl clfCenterService;
    @Autowired
    private PhoneInfoService phoneInfoService;
    @Autowired
    private LoanOperationService loanOperationService;
    @Autowired
    private ICardCheckRecordRepository iCardCheckRecordRepository;
    @Autowired
    private UrlRequestConfigRespository urlRequestConfigRespository;

    private ClfChannelConfiguration clfChannelConfiguration;
    private  String md5Keywy = "qEAxMJBv";
    private  String aesKeywy = "sxD8KO79EDK0N0AJ";


    /**
    *申请提现请求
    * */
    @Override
    public Result applyLoan(OneClickData oneClickData) {
        JSONObject result=null;
        //通过用户id获取产品信息
//        QuotaCredit quotaCredit=phoneInfoService.selectUserAuditRecords(Long.valueOf(oneClickData.getUserId()), Long.parseLong(oneClickData.getChannelCode()));
//        log.info("打印quotaCredit={}",quotaCredit);
        //获取当前的渠道秘钥
//        clfChannelConfiguration=clfCenterService.findChannelConfigurationByChannelId(Long.parseLong(oneClickData.getChannelCode().trim()));
//        log.info("oneClickData={}",oneClickData);
//        md5Keywy=clfChannelConfiguration.getMd5Key();
//        aesKeywy=clfChannelConfiguration.getAesKey();
//        result= applyLoan(oneClickData, md5Keywy, aesKeywy);
          result=reApplyLoan(oneClickData);
          String context=result.get("context").toString().trim();
        if(!StringUtils.isBlank(context)){
            String getDecryption = AESUtil.decryptAfterBase64Decode(context, aesKeywy);

            log.info("解密的getDecryption的结果={}" , getDecryption);

            JSONObject getDecryptionResult = (JSONObject) JSONObject.parse(getDecryption);
            log.info("打印一下getDecryptionResult={}",getDecryptionResult.get("bizData"));
            JSONObject bizData= (JSONObject) JSONObject.parse(getDecryptionResult.get("bizData").toString());
            log.info("提现结果打印bizData={}",bizData);
            String code=bizData.get("code").toString();
            String codeCompare="0";
            String businessCode=bizData.get("businessCode").toString();
            String businessCodeCompare="0000";
            String msg=bizData.get("msg").toString().trim();
            log.info("msg={}",msg);
            boolean isOk=(codeCompare.equals(code) && businessCodeCompare.equals(businessCode))|| "订单已经提现签约过".equals(msg)||("0".equals(code) && "0200".equals(businessCode));
            if(isOk){
                // 通过userid查看当前的提现记录是否生成放款loanid
                LoanApplicationHistory applicationHistory=new LoanApplicationHistory();
//            log.info("oneClickData.getUserId()={},quotaCredit.getProductType()={}",oneClickData.getUserId(),quotaCredit.getProductType());
                applicationHistory= loanOperationService.selectLoanId(Long.valueOf(oneClickData.getUserId()), oneClickData.getBizType());
                log.info("打印获取的放款单信息applicationHistory={}",applicationHistory);
                if(Objects.isNull(applicationHistory)){
                    applicationHistory=verificationApplicationHistory(applicationHistory,Long.valueOf(oneClickData.getUserId().trim()), oneClickData.getBizType(),0);
                }else{
                    log.info("打印放款id,applicationHistory.getId()={}",applicationHistory.getId());
                }
                return new Result(ApplicationStatus.SUCCESS,new OneClickMsgResult(applicationHistory.getId().toString().trim(),LoanStatusEnum.APPLY_WITHDRAWDEPOSIT.getDesc(),CreditStatusEnum.CREDIT_SUCC.getDesc()));
            }else{
                return Result.buildFail(msg) ;
            }
        }else {
            return Result.buildFail("获取结果值空context={}",context) ;

        }
    }

    public JSONObject reApplyLoan(OneClickData oneClickData){
        JSONObject result=null;
        //通过用户id获取产品信息
//        QuotaCredit quotaCredit=phoneInfoService.selectUserAuditRecords(Long.valueOf(oneClickData.getUserId()), Long.parseLong(oneClickData.getChannelCode()));
//        log.info("打印quotaCredit={}",quotaCredit);
        //获取当前的渠道秘钥
        clfChannelConfiguration=clfCenterService.findChannelConfigurationByChannelId(Long.parseLong(oneClickData.getChannelCode().trim()));
        log.info("oneClickData={}",oneClickData);
        md5Keywy=clfChannelConfiguration.getMd5Key();
        aesKeywy=clfChannelConfiguration.getAesKey();
        result= applyLoan(oneClickData, md5Keywy, aesKeywy);
        return result;
    }


   public LoanApplicationHistory verificationApplicationHistory(LoanApplicationHistory applicationHistory,Long userId,Integer businessType,int num){
       if(Objects.isNull(applicationHistory)){
           applicationHistory = loanOperationService.selectLoanId(userId, businessType);
           int numsum=50;
           if(num< numsum&& Objects.isNull(applicationHistory)){
               num++;
               verificationApplicationHistory(applicationHistory,userId, businessType,num);
           }else{
               log.info("打印一下最终的quotaCredit={}", applicationHistory);
           }
       }
       return applicationHistory;
   }

    public JSONObject applyLoan(OneClickData oneClickData,String md5Keywy,String aesKeywy){
        JSONObject result =null;
        String bankCardNumber=  BankCardNumberGenerator.generate(BankNameEnum.CCB, BankCardTypeEnum.DEBIT);
        String bankCode="CCB";
        String bankName="建设银行";
        boolean formIdIsTrue=oneClickData.getFundCorpId().equals(ResposeResultEnum.FUNDCORPID910.getDesc()) || oneClickData.getFundCorpId().equals(ResposeResultEnum.FUNDCORPID920.getDesc()) || oneClickData.getFundCorpId().equals(ResposeResultEnum.FUNDCORPID940.getDesc());
        //走老提现逻辑或者走配置提现逻辑
        boolean isOldApplyMethod=oneClickData.getChannelCode().equals(ChannelEnum.ZHANGHZONG.getCode()) || oneClickData.getChannelCode().equals(ChannelEnum.SHIGUANGFQ.getCode())
                || oneClickData.getChannelCode().equals(ChannelEnum.XIAOJUMAO.getCode()) || oneClickData.getChannelCode().equals(ChannelEnum.GUOMEI.getCode())
                || oneClickData.getChannelCode().equals(ChannelEnum.WEIDIAN.getCode()) ;
        if(formIdIsTrue){
            bankCardNumber=getBankCardNumberLasterNumberIsEvenNumbers();

            if(oneClickData.getType() == TypeEnum.LOANFAIL.getCode()){
                //取奇数
                bankCardNumber = getBankCardNumberLasterNumberIsOppNumbers();
            }

            bankCode="PAB";
            bankName="平安银行";
            log.info("在提现之前在payment_center`.`card_check_record`插入银行卡，去报gu-bei是非mock哦={}", bankCardNumber);
            CardCheckRecordEntity cardCheckRecordEntity=new CardCheckRecordEntity();
            cardCheckRecordEntity.setCardNo(bankCardNumber);
            cardCheckRecordEntity.setBankCode(bankCode);
            cardCheckRecordEntity.setBankName(bankName);
            cardCheckRecordEntity.setCardType(CardType.DEBIT_CARD);
            CardCheckRecordEntity cardCheckRecordEntityReslut=iCardCheckRecordRepository.save(cardCheckRecordEntity);
//            result=getH5CashWithdrawal(oneClickData,md5Keywy,aesKeywy,bankCardNumber,bankCode,bankName);
            log.info("获取当前的卡信息={}",cardCheckRecordEntityReslut);

            if(Objects.nonNull(cardCheckRecordEntityReslut)){
                if(isOldApplyMethod){
                    result=getAPICashWithdrawal(oneClickData, md5Keywy, aesKeywy, bankCardNumber, bankCode, bankName);
                }else{
                    result=getGeneralCashWithdrawal(oneClickData, md5Keywy, aesKeywy, bankCardNumber, bankCode, bankName);
                }
            }else {
                log.info("插入支付中心卡信息失败了");
            }

        }else{
            log.info("非云信的资方={}",isOldApplyMethod);
            if(isOldApplyMethod){
                result=getAPICashWithdrawal(oneClickData, md5Keywy, aesKeywy, bankCardNumber, bankCode, bankName);
            }else{
                result=getGeneralCashWithdrawal(oneClickData, md5Keywy, aesKeywy, bankCardNumber, bankCode, bankName);
            }
        }
        return result;
    }

    public JSONObject getAPICashWithdrawal(OneClickData oneClickData,String md5Keywy,String aesKeywy,String bankCardNumber,String bankCode, String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        String channelCode="ZHANGZHONG";
        String url ="";
        if(oneClickData.getChannelCode().trim().equals(ChannelEnum.ZHANGHZONG.getCode())){
            channelCode="ZHANGZHONG";
            paras= applyZhangZhongLoan(oneClickData,bankCardNumber,bankCode,bankName);
        }else if(oneClickData.getChannelCode().equals(ChannelEnum.SHIGUANGFQ.getCode())){
            channelCode="SHIGUANGFQ";
            paras= applyShiGuangFenQiLoan(oneClickData, bankCardNumber, bankCode, bankName);
        }else if(oneClickData.getChannelCode().equals(ChannelEnum.XIAOJUMAO.getCode())){
            channelCode="XIAOJUMAO";
            paras= applyXiaoJMLoan(oneClickData, bankCardNumber, bankCode, bankName);

        }else if(oneClickData.getChannelCode().equals(ChannelEnum.GUOMEI.getCode())){
            channelCode="GUOMEI";
            paras= applyGuoMeiLoan(oneClickData, bankCardNumber, bankCode, bankName);
        }else if(oneClickData.getChannelCode().equals(ChannelEnum.WEIDIAN.getCode())){
            channelCode="WEIDIAN";
            paras= applyWeiDianLoan(oneClickData, bankCardNumber, bankCode, bankName);

        }else if(oneClickData.getChannelCode().equals(ChannelEnum.WEIDIAN.getCode())){
            channelCode="BUCUNZAI";
            log.info("小牛提现暂时不支持，后续流程不确定");

        }else{
            //从配置中获取

        }

        url=qapiHttp+"/ex/api/v2/withdraw/"+channelCode;

        String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

        Map<String,String> content_map = new HashMap<String, String>();
        content_map.put("content",encryptContent);
        log.info("获取当前的paras={}", paras);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, content_map);
        log.info("打印一下提现返回结果：{}",result);
        return result;
    }


    public JSONObject getGeneralCashWithdrawal(OneClickData oneClickData,String md5Keywy,String aesKeywy,String bankCardNumber,String bankCode, String bankName){
        JSONObject result = null;
        // 通过渠道code获取当前的配置
        UrlRequestConfig urlRequestConfig=urlRequestConfigRespository.findByChannelCcode(oneClickData.getChannelCode(), "withdraw");
        log.info("获取当前的urlRequestConfig={}",urlRequestConfig);
         //通过channel_order_no渠道订单号
        String url = qapiHttp+urlRequestConfig.getUrlPath(); //url获取
        if(!StringUtils.isNotEmpty(url)){
            return  result;
        }
        String parasOrig=urlRequestConfig.getUrlParamJson();
        String paras=getCovParas(oneClickData,parasOrig,bankCardNumber,bankCode,bankName); //获取json数据
        String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

        if(urlRequestConfig.getParamType().equals("string")) {
            String content_map = "{\"content\":\"" + encryptContent + "\"}";
            log.info("打印一下url={}", url);
            log.info("查看结果content={}", content_map);
            result = HttpRequest.doPostReturnResponseJson(url, content_map);
        }else {
            Map<String,String> content_map = new HashMap<String, String>();
            content_map.put("content", encryptContent);
            log.info("查看结果content={}", content_map);
            result = HttpRequest.doPostReturnResponseJson(url, content_map);
        }
        return result;
    }


    public String getCovParas(OneClickData oneClickData,String parasOrig,String bankCardNumber,String bankCode ,String bankName){
        String newParas="";
        newParas=parasOrig.replace("{channelOrderNumber}",oneClickData.getChannelOrderNo());
        newParas=newParas.replace("{bankCardNumber}",bankCardNumber);
        newParas=newParas.replace("{bankCode}",bankCode);
        newParas=newParas.replace("{bankName}",bankName);
        newParas=newParas.replace("{reservePhoneNumber}",oneClickData.getPhone());
        return newParas;
    }


    public JSONObject getH5CashWithdrawal(OneClickData oneClickData,String md5Keywy,String aesKeywy,String bankCardNumber,String bankCode, String bankName){
        return null;

    }

    /**
     * 掌众的申请提现
     * */
    public Map<String,String> applyZhangZhongLoan(OneClickData oneClickData,String bankCardNumber,String bankCode,String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber", oneClickData.getPhone());


        return paras;
    }


    /**
     * 时光分期的申请提现
     * */
    public Map applyShiGuangFenQiLoan(OneClickData oneClickData,String bankCardNumber,String bankCode,String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber", oneClickData.getPhone());
        log.info("获取当前的paras={}", paras);
        return paras;
    }


    /**
     * 小桔猫的申请提现
     * */
    public Map applyXiaoJMLoan(OneClickData oneClickData,String bankCardNumber,String bankCode,String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber", oneClickData.getPhone());
        return paras;
    }

    /**
     * 国美的申请提现
     * */
    public Map applyGuoMeiLoan(OneClickData oneClickData,String bankCardNumber,String bankCode,String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber", oneClickData.getPhone());
        return paras;
    }



    /**
     * 微店的申请提现
     * */
    public Map applyWeiDianLoan(OneClickData oneClickData,String bankCardNumber,String bankCode,String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber", oneClickData.getPhone());
        return paras;
    }


    /**
     * 微店的申请提现
     * */
    public Map applyGeneralLoan(OneClickData oneClickData,String bankCardNumber,String bankCode,String bankName){
        Map<String,String> paras = new HashMap<String, String>();
        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber", oneClickData.getPhone());
        return paras;
    }
    /**
   * 掌众老的申请提现
   * */
    public JSONObject applyZhangZhongLoanOld(OneClickData oneClickData,String md5Keywy,String aesKeywy){
        String url = qapiHttp+"/ex/api/v2/withdraw/ZHANGZHONG";
        //       并且绑卡的银行卡号必须是偶数、支付中心增加一条数据
        String bankCardNumber=  BankCardNumberGenerator.generate(BankNameEnum.CCB, BankCardTypeEnum.DEBIT);
        String bankCode="CCB";
        String bankName="建设银行";
        JSONObject result =null;
        boolean formIdIsTrue=oneClickData.getFundCorpId().equals(ResposeResultEnum.FUNDCORPID910.getDesc()) || oneClickData.getFundCorpId().equals(ResposeResultEnum.FUNDCORPID920.getDesc()) || oneClickData.getFundCorpId().equals(ResposeResultEnum.FUNDCORPID940.getDesc());
        if(formIdIsTrue){
            bankCardNumber=getBankCardNumberLasterNumberIsEvenNumbers();
            bankCode="PAB";
            bankName="平安银行";
        }else {

            Map<String, String> paras = new HashMap<String, String>();
            paras.put("channelOrderNumber", oneClickData.getChannelOrderNo());
            paras.put("bankCardNumber", bankCardNumber);
            paras.put("bankCode", bankCode);
            paras.put("bankName", bankName);
            paras.put("reservePhoneNumber", oneClickData.getPhone());

            String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

            Map<String, String> content_map = new HashMap<String, String>();
            content_map.put("content", encryptContent);
            log.info("获取当前的paras={}", paras);
            result = HttpRequest.doPostReturnResponseJson(url, content_map);

        }
        return result;
    }


       public static String getBankCardNumberLasterNumberIsEvenNumbers(){
        String bankCardNumberOrigan=BankCardNumberGenerator.generate(BankNameEnum.PAB, BankCardTypeEnum.DEBIT);
        String bankCardNumber="";
        char bankCardNumberOriganCv=bankCardNumberOrigan.charAt(bankCardNumberOrigan.length() - 1);
        int isEven=bankCardNumberOriganCv % 2;
        if( isEven== 0){
            log.info("获取当前的bankCardNumberOrigan={},bankCardNumberOriganCv={}",bankCardNumberOrigan,bankCardNumberOriganCv);
            // 在支付中心插入一条绑卡信息
            bankCardNumber=bankCardNumberOrigan;
        }else {
            getBankCardNumberLasterNumberIsEvenNumbers();

        }
        return bankCardNumber;
    }


    public static String getBankCardNumberLasterNumberIsOppNumbers(){
        String bankCardNumberOrigan=BankCardNumberGenerator.generate(BankNameEnum.PAB, BankCardTypeEnum.DEBIT);
        String bankCardNumber="";
        char bankCardNumberOriganCv=bankCardNumberOrigan.charAt(bankCardNumberOrigan.length() - 1);
        int isEven=bankCardNumberOriganCv % 2;
        if( isEven== 0){
            getBankCardNumberLasterNumberIsOppNumbers();

        } else {
            log.info("获取当前奇数的bankCardNumberOrigan={},bankCardNumberOriganCv={}",bankCardNumberOrigan,bankCardNumberOriganCv);
            bankCardNumber=bankCardNumberOrigan;

        }
        return bankCardNumber;
    }

    /**
     * 时光分期老的申请提现
     * */
    public JSONObject applyShiGuangFenQiLoanOld(OneClickData oneClickData,String md5Keywy,String aesKeywy){
        String url = qapiHttp+"/ex/api/v2/withdraw/SHIGUANGFQ";


        String bankCardNumber=  BankCardNumberGenerator.generate(BankNameEnum.CCB, BankCardTypeEnum.DEBIT);
        String bankCode="CCB";
        String bankName="建设银行";
        Map<String,String> paras = new HashMap<String, String>();

        paras.put("channelOrderNumber",oneClickData.getChannelOrderNo());
        paras.put("bankCardNumber",bankCardNumber);
        paras.put("bankCode",bankCode);
        paras.put("bankName",bankName);
        paras.put("reservePhoneNumber",oneClickData.getPhone());

        String encryptContent = GetEncryptContentAndMd5.getEncryptContent(paras, aesKeywy, md5Keywy);

        Map<String,String> content_map = new HashMap<String, String>();
        content_map.put("content",encryptContent);
        log.info("获取当前的paras={}",paras);
        JSONObject result = HttpRequest.doPostReturnResponseJson(url, content_map);


        return result;
    }

public static void main(String[] args){
//    String bankNum=getBankCardNumberLasterNumberIsEvenNumbers();
//    log.info("获取银行卡={}",bankNum);
//    String bankNum1=getBankCardNumberLasterNumberIsOppNumbers();
//
//    log.info("获取银行卡1={}",bankNum1);



}


}
