package cn.quantgroup.cashloanflowboss.api.role.controller;

import cn.quantgroup.cashloanflowboss.api.role.entity.Role;
import cn.quantgroup.cashloanflowboss.api.role.model.RoleModel;
import cn.quantgroup.cashloanflowboss.api.role.model.RoleModelVo;
import cn.quantgroup.cashloanflowboss.api.role.model.RoleQueryModel;
import cn.quantgroup.cashloanflowboss.api.role.service.RoleService;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * function:
 * date: 2019/9/26
 *
 * @author: suntao
 */
@RestController
@RequestMapping("role")
public class RoleController {

    @Autowired
    private RoleService roleService;

    @GetMapping("list")
    //@Security(authorityId = "Role.roleList")
    public Result<Page<Role>> roleList(@Valid RoleQueryModel roleQueryModel) {
        return roleService.getRoleByName(roleQueryModel);
    }


    @DeleteMapping("delete/{roleId}")
    //@Security(authorityId = "Role.delete")
    public Result<Boolean> deleteRole(@PathVariable Long roleId) {
        return roleService.deleteRole(roleId);
    }


    @PostMapping("save")
    //@Security(authorityId = "Role.saveRole")
    public Result<Boolean> saveRole(@RequestBody @Valid RoleModelVo roleModelVo) {

        return roleService.addRole(roleModelVo);
    }

    @PutMapping("update")
   // @Security(authorityId = "Role.update")
    public Result<Boolean> updateRole(@RequestBody @Valid RoleModelVo roleModelVo){
        return roleService.modifyRole(roleModelVo);
    }

    @GetMapping("/all")
    public Result<List<RoleModel>> getAll(){
        return roleService.getAll();
    }

}
