package cn.quantgroup.cashloanflowboss.api.channel.util;
import java.sql.Timestamp;
import cn.quantgroup.cashloanflowboss.spi.clf.model.KANoticeType;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderCallBack;
import cn.quantgroup.cashloanflowboss.spi.clf.model.CallbackRouter;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfCallbackConfiguration;
import cn.quantgroup.cashloanflowboss.spi.clf.model.EncType;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import cn.quantgroup.cashloanflowboss.api.channel.entity.boss.ChannelConf;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfAddModel;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfBaseModel;
import cn.quantgroup.cashloanflowboss.api.channel.model.ChannelConfVo;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfChannelConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

/**
 * function:
 * date: 2019/8/2
 *
 * @author: suntao
 */
public class ChannelConfUtil {


    public static final String channelRoleName = "channel_role";
    public static final String channelIdParamName = "channelId";

    public static ChannelConfVo channelConfConvertVOModel(ChannelConf channelConf) {
        ChannelConfBaseModel channelConfBaseModel = new ChannelConfBaseModel();
        BeanUtils.copyProperties(channelConf, channelConfBaseModel);

        ChannelConfAddModel channelConfAddModel = new ChannelConfAddModel();
        BeanUtils.copyProperties(channelConf, channelConfAddModel);

        ChannelConfVo channelConfVo = new ChannelConfVo();
        channelConfVo.setBasicInfo(channelConfBaseModel);
        channelConfVo.setAddInfo(channelConfAddModel);

        return channelConfVo;
    }

    public static ChannelConf voModelConfConvertChannelConf(ChannelConfVo channelConfVo) {

        ChannelConfBaseModel channelConfBaseModel = channelConfVo.getBasicInfo();
        ChannelConfAddModel channelConfAddModel = channelConfVo.getAddInfo();

        ChannelConf channelConf = new ChannelConf();
        BeanUtils.copyProperties(channelConfBaseModel, channelConf);

        channelConf.setChannelIp(channelConfAddModel.getChannelIp());
        channelConf.setEnvPath(String.format("http://qapi-%s.liangkebang.net/", channelConfBaseModel.getEnv()));
        channelConf.setApproveCallBackUrl(channelConfAddModel.getApproveCallBackUrl());
        channelConf.setOrderStatusCallBackUrl(channelConfAddModel.getOrderStatusCallBackUrl());
        channelConf.setRepayResultCallBackUrl(channelConfAddModel.getRepayResultCallBackUrl());
        channelConf.setRepaymentPlanCallBackUrl(channelConfAddModel.getRepaymentPlanCallBackUrl());
        channelConf.setUpdateTime(new Date());

        return channelConf;
    }

    public static ClfChannelConfiguration convert2ClfChannelConfiguration(ChannelConfBaseModel basicInfo) {
        ClfChannelConfiguration channelConfiguration = new ClfChannelConfiguration();
        channelConfiguration.setChannelName(basicInfo.getChannelName());
        channelConfiguration.setChannelCode(basicInfo.getChannelCode());
        channelConfiguration.setRegisteredFrom(basicInfo.getChannelId());
        channelConfiguration.setIsActive(true);
        channelConfiguration.setIsRequestStandard(true);
        channelConfiguration.setEncType(EncType.AES);
        channelConfiguration.setAesKey(basicInfo.getAesKey());
        channelConfiguration.setMd5Key(basicInfo.getMd5Key());
        channelConfiguration.setSpiderCenterChannelCode(basicInfo.getRiskCode());
        channelConfiguration.setSpiderCenterMerchantChannelCode(basicInfo.getAuthCode());
        return channelConfiguration;
    }

    public static ClfCallbackConfiguration convert2ClfCallbackConfiguration(ChannelConfBaseModel basicInfo) {
        ClfCallbackConfiguration clfCallbackConfiguration = new ClfCallbackConfiguration();
        clfCallbackConfiguration.setChannelId(basicInfo.getChannelId());
        clfCallbackConfiguration.setIsLoanMakeup(false);
        clfCallbackConfiguration.setIsRepayMakeup(false);
        clfCallbackConfiguration.setLoanMakeupStrategy("");
        clfCallbackConfiguration.setRepayMakeupStrategy("");
        clfCallbackConfiguration.setIsActive(true);
        clfCallbackConfiguration.setOnlyNewUser(false);
        clfCallbackConfiguration.setCallbackServiceName(basicInfo.getChannelCode());
        clfCallbackConfiguration.setCallbackNoPushProgress("");
        clfCallbackConfiguration.setPreProgress("");
        clfCallbackConfiguration.setRetryMaxTimes(5L);
        clfCallbackConfiguration.setCallbackRouter(CallbackRouter.API);

        return clfCallbackConfiguration;
    }

    public static List<ClfOrderCallBack> convert2ClfOrderCallback(Long channelId, ChannelConfAddModel addModel) {

        List<ClfOrderCallBack> list = new ArrayList<>();
        if (StringUtils.isNotEmpty(addModel.getApproveCallBackUrl())) {
            //审批
            ClfOrderCallBack clfOrderCallBack1 = new ClfOrderCallBack();
            clfOrderCallBack1.setCallbackStatus(KANoticeType.FUAD_ASSIFN_SUCC);
            clfOrderCallBack1.setRegisteredFrom(channelId);
            clfOrderCallBack1.setCallbackUrl(addModel.getApproveCallBackUrl());
            clfOrderCallBack1.setIsActive(true);
            clfOrderCallBack1.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            list.add(clfOrderCallBack1);

            ClfOrderCallBack clfOrderCallBack2 = new ClfOrderCallBack();
            clfOrderCallBack2.setCallbackStatus(KANoticeType.REJECT);
            clfOrderCallBack2.setRegisteredFrom(channelId);
            clfOrderCallBack2.setCallbackUrl(addModel.getApproveCallBackUrl());
            clfOrderCallBack2.setIsActive(true);
            clfOrderCallBack2.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            list.add(clfOrderCallBack2);
        }

        if (StringUtils.isNotEmpty(addModel.getOrderStatusCallBackUrl())) {

            // 状态
            ClfOrderCallBack clfOrderCallBack0 = new ClfOrderCallBack();
            clfOrderCallBack0.setCallbackStatus(KANoticeType.CREDIT_SUCC);
            clfOrderCallBack0.setRegisteredFrom(channelId);
            clfOrderCallBack0.setCallbackUrl(addModel.getOrderStatusCallBackUrl());
            clfOrderCallBack0.setIsActive(true);
            clfOrderCallBack0.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            list.add(clfOrderCallBack0);

            ClfOrderCallBack clfOrderCallBack3 = new ClfOrderCallBack();
            clfOrderCallBack3.setCallbackStatus(KANoticeType.WITHDRAW);
            clfOrderCallBack3.setRegisteredFrom(channelId);
            clfOrderCallBack3.setCallbackUrl(addModel.getOrderStatusCallBackUrl());
            clfOrderCallBack3.setIsActive(true);
            clfOrderCallBack3.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            list.add(clfOrderCallBack3);

            ClfOrderCallBack clfOrderCallBack4 = new ClfOrderCallBack();
            clfOrderCallBack4.setCallbackStatus(KANoticeType.FUND_SUCC);
            clfOrderCallBack4.setRegisteredFrom(channelId);
            clfOrderCallBack4.setCallbackUrl(addModel.getOrderStatusCallBackUrl());
            clfOrderCallBack4.setIsActive(true);
            clfOrderCallBack4.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            list.add(clfOrderCallBack4);

            ClfOrderCallBack clfOrderCallBack5 = new ClfOrderCallBack();
            clfOrderCallBack5.setCallbackStatus(KANoticeType.FUND_FAIL);
            clfOrderCallBack5.setRegisteredFrom(channelId);
            clfOrderCallBack5.setCallbackUrl(addModel.getOrderStatusCallBackUrl());
            clfOrderCallBack5.setIsActive(true);
            clfOrderCallBack5.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            list.add(clfOrderCallBack5);

            ClfOrderCallBack clfOrderCallBack6 = new ClfOrderCallBack();
            clfOrderCallBack6.setCallbackStatus(KANoticeType.FUND_WITHDRAW_SUCC);
            clfOrderCallBack6.setRegisteredFrom(channelId);
            clfOrderCallBack6.setCallbackUrl(addModel.getOrderStatusCallBackUrl());
            clfOrderCallBack6.setIsActive(true);
            clfOrderCallBack6.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            list.add(clfOrderCallBack6);

            ClfOrderCallBack clfOrderCallBack7 = new ClfOrderCallBack();
            clfOrderCallBack7.setCallbackStatus(KANoticeType.CANCEL_LOAN);
            clfOrderCallBack7.setRegisteredFrom(channelId);
            clfOrderCallBack7.setCallbackUrl(addModel.getOrderStatusCallBackUrl());
            clfOrderCallBack7.setIsActive(true);
            clfOrderCallBack7.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            list.add(clfOrderCallBack7);

            ClfOrderCallBack clfOrderCallBack8 = new ClfOrderCallBack();
            clfOrderCallBack8.setCallbackStatus(KANoticeType.CANCEL_AFTER_LOAN);
            clfOrderCallBack8.setRegisteredFrom(channelId);
            clfOrderCallBack8.setCallbackUrl(addModel.getOrderStatusCallBackUrl());
            clfOrderCallBack8.setIsActive(true);
            clfOrderCallBack8.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            list.add(clfOrderCallBack8);

            ClfOrderCallBack clfOrderCallBack9 = new ClfOrderCallBack();
            clfOrderCallBack9.setCallbackStatus(KANoticeType.ALL_REPAID);
            clfOrderCallBack9.setRegisteredFrom(channelId);
            clfOrderCallBack9.setCallbackUrl(addModel.getOrderStatusCallBackUrl());
            clfOrderCallBack9.setIsActive(true);
            clfOrderCallBack9.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            list.add(clfOrderCallBack9);
        }

        if (StringUtils.isNotEmpty(addModel.getRepaymentPlanCallBackUrl())) {
            ClfOrderCallBack clfOrderCallBack10 = new ClfOrderCallBack();
            clfOrderCallBack10.setCallbackStatus(KANoticeType.REPAYMENT);
            clfOrderCallBack10.setRegisteredFrom(channelId);
            clfOrderCallBack10.setCallbackUrl(addModel.getRepaymentPlanCallBackUrl());
            clfOrderCallBack10.setIsActive(true);
            clfOrderCallBack10.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            list.add(clfOrderCallBack10);
        }

        return list;
    }
}
