package cn.quantgroup.cashloanflowboss.api.channel.service;

import cn.quantgroup.cashloanflowboss.api.channel.entity.ChannelConf;
import cn.quantgroup.cashloanflowboss.api.channel.model.*;
import cn.quantgroup.cashloanflowboss.api.channel.repository.ChannelConfRepository;
import cn.quantgroup.cashloanflowboss.api.channel.util.ChannelConfUtil;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ChannelApplyInfoStrategy;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfCallbackConfiguration;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfChannelConfiguration;
import cn.quantgroup.cashloanflowboss.spi.clf.entity.ClfOrderCallBack;
import cn.quantgroup.cashloanflowboss.spi.clf.model.KANoticeType;
import cn.quantgroup.cashloanflowboss.spi.clf.service.CLFCenterService;
import cn.quantgroup.cashloanflowboss.utils.IgnorePropertiesUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * function:
 * date: 2019/8/2
 *
 * @author: suntao
 */

@Service
public class ChannelConfServiceImpl implements ChannelConfService {

    @Autowired
    private CLFCenterService clfCenterService;

    @Autowired
    private ChannelConfRepository channelConfRepository;


    @Override
    public Page<ChannelListModel> getChannelInfo(Integer pageNumber, Integer pageSize, Long channelId, String channelName) {

        Page<ClfChannelConfiguration> page = clfCenterService.findChannelConfigurationByCriteriaQueryPage(pageNumber, pageSize, channelId, channelName);

        Page<ChannelListModel> channelListModelPage = page.map(it -> {
            ChannelListModel channelListModel = new ChannelListModel();
            channelListModel.setChannelId(it.getRegisteredFrom());
            channelListModel.setChannelName(it.getChannelName());
            channelListModel.setChannelCode(it.getChannelCode());
            channelListModel.setBizType(null);
            channelListModel.setCreatedAt(it.getCreatedAt());
            return channelListModel;
        });

        return channelListModelPage;
    }

    @Override
    public ChannelConfVo getChannelConf(Long channelId) {
        ChannelConf channelConf = channelConfRepository.getByChannelId(channelId);

        ChannelConfVo channelConfVo;
        if (channelConf != null) {
            channelConfVo = ChannelConfUtil.channelConfConvertVOModel(channelConf);
        } else {
            // boss channel_conf 为空，从clf 查询数据
            ClfChannelConfiguration channelConfiguration = clfCenterService.findChannelConfigurationByChannelId(channelId);

            ClfOrderCallBack approve = clfCenterService.findOrderCallBackByByCallbackStatusAndChannelId(KANoticeType.FUAD_ASSIFN_SUCC.name(), channelId);
            ClfOrderCallBack orderStatus = clfCenterService.findOrderCallBackByByCallbackStatusAndChannelId(KANoticeType.FUND_SUCC.name(), channelId);
            ClfOrderCallBack repaymentPlan = clfCenterService.findOrderCallBackByByCallbackStatusAndChannelId(KANoticeType.REPAYMENT.name(), channelId);

            channelConfVo = ChannelConfUtil.getChannelConfVoByClf(channelConfiguration, approve, orderStatus, repaymentPlan);
        }
        List<ChannelApplyInfoStrategy> channelApplyInfoStrategyByChannelId = clfCenterService.findChannelApplyInfoStrategyByChannelId(channelId);
        channelConfVo.getBasicInfo().setChannelApplyInfoStrategyList(channelApplyInfoStrategyByChannelId);
        return channelConfVo;

    }

    @Override
    public Boolean editChannelConfInfo(ChannelConfVo confVo) {
        ChannelConfBaseModel basicInfo = confVo.getBasicInfo();
        ChannelConfAddModel addInfo = confVo.getAddInfo();

        ChannelConf channelConf = ChannelConfUtil.voModelConfConvertChannelConf(confVo);

        ChannelConf channelConfExsit = channelConfRepository.getByChannelId(basicInfo.getChannelId());

        // cash-loan-flow-boss 库
        if (channelConfExsit == null) {
            // 新保存
            channelConf.setCreateTime(new Date());
            channelConfRepository.save(channelConf);
        } else {
            // 更新数据库 数据
            //BeanUtils.copyProperties(channelConf, channelConfExsit, IgnorePropertiesUtil.getNullPropertyNames(channelConf));
            channelConf.setId(channelConfExsit.getId());
            channelConf.setUpdateTime(new Date());
            channelConfRepository.save(channelConf);
        }

        // clf 库
        ClfChannelConfiguration channelConfiguration = ChannelConfUtil.convert2ClfChannelConfiguration(basicInfo);
        List<ClfOrderCallBack> clfOrderCallBackList = ChannelConfUtil.convert2ClfOrderCallback(basicInfo.getChannelId(), addInfo);
        ClfChannelConfiguration channelConfigurationExsit = clfCenterService.findChannelConfigurationByChannelId(basicInfo.getChannelId());
        if (channelConfigurationExsit == null) {
            // 新保存
            channelConfiguration.setCreatedAt(new Timestamp(System.currentTimeMillis()));
            clfCenterService.saveChannelConfiguration(channelConfiguration);

            ClfCallbackConfiguration clfCallbackConfiguration = ChannelConfUtil.convert2ClfCallbackConfiguration(basicInfo);
            clfCenterService.saveCallbackConfiguration(clfCallbackConfiguration);

            clfCenterService.saveOrderCall(clfOrderCallBackList);
        } else {
            // update
         //   BeanUtils.copyProperties(channelConfiguration, channelConfigurationExsit, IgnorePropertiesUtil.getNullPropertyNames(channelConfiguration));
            channelConfiguration.setId(channelConfigurationExsit.getId());
            clfCenterService.saveChannelConfiguration(channelConfiguration);

            // 更新OrderCallBack
            for (ClfOrderCallBack clfOrderCallBack : clfOrderCallBackList) {
                ClfOrderCallBack orderCallBackExsit = clfCenterService.findOrderCallBackByByCallbackStatusAndChannelId(clfOrderCallBack.getCallbackStatus().name(), clfOrderCallBack.getRegisteredFrom());
                if (orderCallBackExsit != null) {
                    clfOrderCallBack.setId(orderCallBackExsit.getId());
                }
            }
            clfCenterService.saveOrderCall(clfOrderCallBackList);
        }

        //保存进件配置项
        Long channelId = basicInfo.getChannelId();
        List<ChannelApplyInfoStrategy> channelApplyInfoStrategyList = basicInfo.getChannelApplyInfoStrategyList();
        if (CollectionUtils.isNotEmpty(channelApplyInfoStrategyList)) {
            for (ChannelApplyInfoStrategy strategy : channelApplyInfoStrategyList) {
                clfCenterService.saveChannelApplyInfoStrategy(strategy);
            }

        }
        return true;
    }


    @Override
    public List<ChannelModel> getAll() {

        List<ClfChannelConfiguration> all = clfCenterService.findAll();
        List<ChannelModel> channelModelList = new ArrayList<>(all.size());
        all.forEach(e->{
            ChannelModel model = new ChannelModel();
            model.setId(e.getId());
            model.setName(e.getChannelName());
            channelModelList.add(model);
        });
        return channelModelList;

    }
}
