package cn.quantgroup.cashloanflowboss.api.optlog.entity;

import cn.quantgroup.cashloanflowboss.api.optlog.model.OptEnumName;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * 操作日志记录
 * function:
 * date: 2019/8/12
 *
 * @author: suntao
 */

@Data
@Entity
@Table(name = "opt_history_log")
public class OptHistoryLog {

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "channel_order_number")
    private String channelOrderNumber;

    @Column(name = "credit_number")
    private String creditNumber;

    @Column(name = "loan_id")
    private Long loanId;

    @Column(name = "channel_id")
    private Long channelId;

    /**
     * 操作节点名称
     */
    @Column(name = "opt_enum_name")
    private OptEnumName optEnumName;

    /**
     * 操作节点名称
     */
    @Column(name = "opt_name")
    private String optName;

    /**
     * 操作节点名称
     */
    @Column(name = "opt_user")
    private String optUser;

    /**
     * 操作详细日志
     */
    @Column(name = "opt_log_detail")
    private String optLogDetail;

    /**
     * 操作详细日志
     */
    @Column(name = "ext_data")
    private String extData;

    /** 0:失败；1：成功 */
    @Column(name = "opt_result")
    private Boolean optResult;

    @Column(name = "create_time")
    private Date createTime;
}
