package cn.quantgroup.cashloanflowboss.utils;


import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by shang on 2019/7/22.
 */
public class ChineseIDCardNumberGenerator {
    public static String generate() {
        Map<String, String> code = getAreaCode();
        String areaCode = code.keySet().toArray(new String[0])[RandomUtils
                .nextInt(0, code.size())]
                + StringUtils.leftPad((RandomUtils.nextInt(0, 9998) + 1) + "", 4,
                "0");

        String birthday = new SimpleDateFormat("yyyyMMdd").format(randomDate());
        String randomCode = String.valueOf(1000 + RandomUtils.nextInt(0, 999))
                .substring(1);
        String pre = areaCode + birthday + randomCode;
        String verifyCode = getVerifyCode(pre);
        String result = pre + verifyCode;

        return result;
    }

    private static Date randomDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1970, 1, 1);
        long earlierDate = calendar.getTime().getTime();
        calendar.set(2000, 1, 1);
        long laterDate = calendar.getTime().getTime();

        long chosenDate = RandomUtils.nextLong(earlierDate, laterDate);

        return new Date(chosenDate);
    }

    private static String getVerifyCode(String cardId) {
        String[] ValCodeArr = { "1", "0", "X", "9", "8", "7", "6", "5", "4",
                "3", "2" };
        String[] Wi = { "7", "9", "10", "5", "8", "4", "2", "1", "6", "3", "7",
                "9", "10", "5", "8", "4", "2" };
        int tmp = 0;
        for (int i = 0; i < Wi.length; i++) {
            tmp += Integer.parseInt(String.valueOf(cardId.charAt(i)))
                    * Integer.parseInt(Wi[i]);
        }

        int modValue = tmp % 11;
        String strVerifyCode = ValCodeArr[modValue];

        return strVerifyCode;
    }

    private static Map<String, String> getAreaCode() {
        final Map<String, String> map = new HashMap<String,String>();
        map.put("11", "����");
        map.put("12", "���");
        map.put("13", "�ӱ�");
        map.put("14", "ɽ��");
        map.put("15", "���ɹ�");
        map.put("21", "����");
        map.put("22", "����");
        map.put("23", "������");
        map.put("31", "�Ϻ�");
        map.put("32", "����");
        map.put("33", "�㽭");
        map.put("34", "����");
        map.put("35", "����");
        map.put("36", "����");
        map.put("37", "ɽ��");
        map.put("41", "����");
        map.put("42", "����");
        map.put("43", "����");
        map.put("44", "�㶫");
        map.put("45", "����");
        map.put("46", "����");
        map.put("50", "����");
        map.put("51", "�Ĵ�");
        map.put("52", "����");
        map.put("53", "����");
        map.put("54", "����");
        map.put("61", "����");
        map.put("62", "����");
        map.put("63", "�ຣ");
        map.put("64", "����");
        map.put("65", "�½�");
        map.put("71", "̨��");
        map.put("81", "���");
        map.put("82", "����");
        map.put("91", "����");

        return map;
    }
}
