package cn.quantgroup.cashloanflowboss.spi.opapi;

import org.springframework.cloud.netflix.feign.FeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;


@Component
@FeignClient(name = "OPCenter", url = "${op.api-host}", fallback = OPCenter.Fallback.class)
public interface OPCenter {

  @GetMapping(value = "/user/login")
  String getToken(@RequestParam("auth") String auth);


  @PostMapping(value = "/clotho/funds/plan/loan/apply", consumes = "application/json")
  String clothoFundsPlanLoanApply(@RequestBody String jsonData);

  @Component
  class Fallback implements OPCenter {

    @Override
    public String getToken(String auth) {
      return null;
    }

    @Override
    public String clothoFundsPlanLoanApply(String jsonData) {
      return null;
    }
  }
}

