package cn.quantgroup.cashloanflowboss.core.aspect;

import cn.quantgroup.cashloanflowboss.api.channel.util.ChannelConfUtil;
import cn.quantgroup.cashloanflowboss.api.login.model.Principal;
import cn.quantgroup.cashloanflowboss.core.Application;
import cn.quantgroup.cashloanflowboss.core.annotation.channelrole.ChannelIdInit;
import cn.quantgroup.cashloanflowboss.core.base.Result;
import cn.quantgroup.cashloanflowboss.utils.JSONTools;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.Order;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * 加载优先级 高于 ChannelRoleCheckAspect
 * function:
 * date: 2019/8/6
 *
 * @author: suntao
 */
@Slf4j
@Component
@Aspect
@Order(1)
public class ChannelRoleLoadAspect {

    @Pointcut("@annotation(cn.quantgroup.cashloanflowboss.core.annotation.channelrole.ChannelIdInit)")
    private void channelIdInit() {}


    @Around(value = "channelIdInit()")
    public Object channelIdInitBefore(ProceedingJoinPoint pjp) {
        Object[] args = pjp.getArgs();
        MethodSignature methodSignature = (MethodSignature) pjp.getSignature();
        Method method = methodSignature.getMethod();

        Principal principal = Application.getPrincipal();
        if (principal == null) {
            try {
                return pjp.proceed(args);
            } catch (Throwable throwable) {
                log.error("请求失败，e={}", ExceptionUtils.getStackTrace(throwable));
                return Result.buildFial();
            }
        }

        // 如果是渠道用户登陆 默认加载channelId
        ChannelIdInit annotation = method.getAnnotation(ChannelIdInit.class);

        if (annotation != null) {

            String channelIdSPEL = annotation.channelIdSPEL();

            if (principal.isChannel()) {
                if (StringUtils.isNotEmpty(channelIdSPEL)) {
                    try {
                        if (channelIdSPEL.startsWith("#this")) {//判断是否是spel表达式
                            Expression expression = new SpelExpressionParser().parseExpression(channelIdSPEL);
                            expression.setValue(args, principal.getChannelId());
                        } else {
                            log.warn("[channelIdInitBefore]channelIdSPEL设置失败");
                        }
                    } catch (ExpressionException e) {
                        log.error("[channelIdInitBefore]key表达式“" + channelIdSPEL + "”错误：{}", e);
                        throw e;
                    }
                }
            }

        }
        try {
            return pjp.proceed(args);
        } catch (Throwable throwable) {
            log.error("请求失败，e={}", ExceptionUtils.getStackTrace(throwable));
            return Result.buildFial();
        }
    }

}
