package cn.quantgroup.cashloanflowboss.api.user.repository;

import cn.quantgroup.cashloanflowboss.api.user.entity.User;
import cn.quantgroup.cashloanflowboss.core.persistence.CashLoanFlowBossDataSource;
import cn.quantgroup.cashloanflowboss.core.persistence.CashLoanFlowBossPubConfDataSource;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * Created by WeiWei on 2019/7/22.
 */
@CashLoanFlowBossPubConfDataSource
@Repository
public interface UserRepository extends JpaRepository<User, Long>, JpaSpecificationExecutor<User> {

    /**
     * 获取用户
     *
     * @param username 用户名
     * @return
     */
    User getUserByUsername(String username);


    @Query(value = "select user.* from user,user_role_mapping urm where  urm.user_id= user.id "+
            "and IF ( ?1 =\"\",1=1, user.nickname = ?1) " +
            "and IF (?2 =\"\", 1=1, urm.role_id= ?2) "
            + "ORDER BY ?#{#pageable}",
            countQuery = "select count(user.id) from user,user_role_mapping urm where  urm.user_id= user.id "+
                    "and IF ( ?1 =\"\",1=1, user.nickname = ?1) " +
                    "and IF (?2 =\"\", 1=1, urm.role_id= ?2) ",
            nativeQuery = true)
    Page<User> getUserByNicknameAndRoleId( String nickname,  String roleId, Pageable pageable);


}
