package cn.quantgroup.cashloanflowboss.spi.clf.entity;

import cn.quantgroup.cashloanflowboss.spi.clf.model.KANoticeType;
import cn.quantgroup.cashloanflowboss.spi.clf.model.LoanProgress;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by 11 on 2016/11/29.
 */
@Data
@Entity
@Table(name = "order_callback")
public class ClfOrderCallBack implements Serializable{
    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "loan_id")
    private Long loanId;

    @Column(name = "progress")
    private LoanProgress progress;

    @Column(name = "callback_status")
    @Enumerated(EnumType.STRING)//保存字面值到数据库
    private KANoticeType callbackStatus;

    @Column(name = "registered_from")
    private Long registeredFrom;

    @Column(name = "callback_url")
    private String callbackUrl;

    @Column(name = "is_active")
    private Boolean isActive = Boolean.TRUE;

    @Column(name = "created_at")
    private Timestamp createdAt = new Timestamp(System.currentTimeMillis());

}