package cn.quantgroup.cashloanflowboss.spi.user.repository;

import cn.quantgroup.cashloanflowboss.api.oneclickdata.entity.OneClickData;
import cn.quantgroup.cashloanflowboss.spi.user.entity.UserDetail;
import cn.quantgroup.cashloanflowboss.spi.user.source.XyqbUserDataSource;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@XyqbUserDataSource
@Repository
public interface UserDetailRepository extends JpaRepository<UserDetail,Long>{

  @Transactional(rollbackFor = Exception.class)
  @Modifying
  @Query(value = "delete from user_detail where user_id = ?1", nativeQuery = true)
  int deleteByUserId(Long userId);

  //     通过phone查找usesr_detail
  @Query(value = "select * from user_detail where phone_no= ?1  order by id desc limit 1", nativeQuery = true)
  UserDetail findByphoneNo(String phoneNo);

}
