package node_up_down

import (
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/pkg/api-server"
	"git.quantgroup.cn/DevOps/enoch/pkg/global"
	"github.com/buaazp/fasthttprouter"
	"github.com/valyala/fasthttp"
	"github.com/vrg0/go-common/registry"
	"strings"
	"testing"
)

func init() {
	consulHosts := strings.Split(global.Config.GetOrDefault(global.NamespaceApplication, "consul.address", ""), ",")
	fmt.Println(consulHosts)

	consulConfig := map[string]interface{}{"dc": "3c", "cluster": consulHosts} //dc固定为3c
	if err := registry.Init("consul", consulConfig); err != nil {
		panic(err)
	}

	api_server.ListenAndServe()
}

//正常上线
var nodeUpFlag = false

func TestNodeUp(t *testing.T) {
	if nodeUpFlag {
		return
	} else {
		nodeUpFlag = true
	}

	//开启服务server
	router := fasthttprouter.New()
	router.Handle("GET", "/tech/health/check", func(ctx *fasthttp.RequestCtx) {
		ctx.SetBodyString("Pong!")
	})

	s := &fasthttp.Server{
		Handler: router.Handler,
	}
	go func() {
		_ = s.ListenAndServe(":12345")
	}()

	//正常服务注册
	req := &fasthttp.Request{}
	req.SetRequestURI("http://127.0.0.1:5555/upstreams/aaaa/targets")
	req.SetBody([]byte(fmt.Sprintf(`{"target":"%s:12345", "weight":11}`, global.LocalIp)))
	req.Header.SetContentType("application/json")
	req.Header.SetMethod("POST")

	resp := &fasthttp.Response{}
	client := &fasthttp.Client{}
	if err := client.Do(req, resp); err != nil {
		t.Error(err)
	}
	if resp.StatusCode() != 200 {
		t.Error(string(resp.Body()))
	}
}

//异常测试：预期返回400错误码，Json解析失败
func TestNodeUp2(t *testing.T) {
	fasthttpArgs := &fasthttp.Args{} //空body
	if code, body, err := fasthttp.Post(nil, "http://127.0.0.1:5555/upstreams/aaaa/targets", fasthttpArgs); err != nil {
		t.Error(err)
	} else if code != 400 || !strings.Contains(string(body), "Json解析失败") {
		t.Error(code, string(body))
	}
}

/*  注：此条测试需要 go-common registry 接入后进行
//异常上线：服务启动失败，注册超时
func TestNodeUp3(t *testing.T) {
	//正常服务注册
	req := &fasthttp.Request{}
	req.SetRequestURI("http://127.0.0.1:5555/upstreams/aaaa/targets")
	req.SetBody([]byte(fmt.Sprintf(`{"target":"%s:22112", "weight":11}`, global.LocalIp)))
	req.Header.SetContentType("application/json")
	req.Header.SetMethod("POST")

	resp := &fasthttp.Response{}
	client := &fasthttp.Client{}
	if err := client.Do(req, resp); err != nil {
		t.Error(err)
	}
	if resp.StatusCode() != 400 || !strings.Contains(string(resp.Body()), "timeout"){
		t.Error(string(resp.Body()))
	}
}
*/

//正常下线
func TestNodeDown(t *testing.T) {
	TestNodeUp(t)

	//下线
	req := &fasthttp.Request{}
	req.SetRequestURI("http://127.0.0.1:5555/upstreams/aaaa/targets")
	req.SetBody([]byte(fmt.Sprintf(`{"target":"%s:12345", "weight":-11}`, global.LocalIp)))
	req.Header.SetContentType("application/json")
	req.Header.SetMethod("POST")

	resp := &fasthttp.Response{}
	client := &fasthttp.Client{}
	if err := client.Do(req, resp); err != nil {
		t.Error(err)
	}
	if resp.StatusCode() != 200 {
		t.Error(string(resp.Body()))
	}
}
