package report_form

import (
	"encoding/json"
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/pkg/global"
	"git.quantgroup.cn/DevOps/enoch/pkg/glog"
	"github.com/valyala/fasthttp"
	"github.com/vrg0/go-common/util"
	"runtime/debug"
	"time"
)

var (
	receiverList = make([]string, 0)
	serviceOwner = make(map[string][]string)
)

func init() {
	global.Config.Watch(global.NamespaceApplication, "report.form.receiver", func(oldCfg string, newCfg string) {
		rList := make([]string, 0)
		if err := json.Unmarshal([]byte(newCfg), &rList); err != nil {
			glog.Error("can not unmarshal json:", err, " ", newCfg)
			return
		}
		receiverList = rList
	})

	global.Config.Watch(global.NamespaceApplication, "service.owner", func(oldCfg string, newCfg string) {
		obj := make(map[string][]string)
		if err := json.Unmarshal([]byte(newCfg), &obj); err != nil {
			glog.Error("can not unmarshal json:", err, " ", newCfg)
			return
		}
		serviceOwner = obj
	})
}

func RegularMail(dir string) {
	if !util.IsDir(dir) {
		return
	}

	go func() {
		defer func() {
			if err := recover(); err != nil {
				glog.Error(err, "\n", string(debug.Stack()))
			}

		}()

		for {
			now := time.Now()
			next := now.Add(time.Hour * 24)
			next = time.Date(next.Year(), next.Month(), next.Day(), 10, 0, 0, 0, next.Location())
			timer := time.NewTimer(next.Sub(now))
			<-timer.C
			timer.Stop()

			//发送邮件
			//周
			if next.Weekday() == time.Monday {
				callSendEmailApi("week", next, "all", receiverList)
			}

			//月
			if next.Day() == 1 {
				callSendEmailApi("month", next, "all", receiverList)
			}
		}
	}()
}

func callSendEmailApi(long string, t time.Time, name string, emailList []string) {
	t = t.Add(time.Hour * -24)
	url := fmt.Sprintf("http://%s:%d/send-email/%s/%02d/%02d/%02d/%s",
		global.LocalIp, global.HttpPort, long, t.Year(), t.Month(), t.Day(), name)
	body, err := json.Marshal(emailList)
	if err != nil {
		glog.Error("can not marshal json", receiverList)
		return
	}
	req := &fasthttp.Request{}
	req.SetRequestURI(url)
	req.Header.SetContentType("application/json")
	req.Header.SetMethod("POST")
	req.SetBody(body)
	resp := &fasthttp.Response{}
	client := &fasthttp.Client{}
	if err := client.Do(req, resp); err != nil {
		glog.Error("请求失败:", err)
		return
	}
	if resp.StatusCode() != 200 {
		glog.Error("发送失败:", resp.StatusCode())
		return
	}
}
