package report_form

import (
	"testing"
	"time"
)

func TestNewNode(t *testing.T) {
	n := 7
	now := time.Now()
	startTime := now.Add(-1 * time.Duration(now.Hour()) * time.Hour)
	startTime = startTime.Add(-1 * time.Duration(now.Minute()) * time.Minute)
	startTime = startTime.Add(-1 * time.Duration(now.Second()) * time.Second)
	startTime = startTime.Add(-1 * time.Duration(now.Nanosecond()))
	startTime = startTime.AddDate(0, 0, -n)
	endTime := startTime.AddDate(0, 0, n)

	node := NewNode("cuishou", "172.16.6.92", startTime, endTime)
	t.Log(node.GetServiceName())
	t.Log(node.GetAddress())
	t.Log("cpu", node.GetAverageCpu(), node.GetMaxCpu())
	t.Log("mem", node.GetAverageMem(), node.GetMaxMem())
	t.Log("disk", node.GetAverageDisk(), node.GetMaxDisk())
	t.Log("thread", node.GetAverageThread(), node.GetMaxThread())
}
