package conf

import (
	"encoding/json"
	"github.com/vrg0/go-common/logger"
	"io/ioutil"
	"net/http"
)

var GlobalConfig = Config{}

func Load(denv string, didc string) {
	url := "http://apollo-" + denv + ".quantgroups.com/configfiles/real_json/enoch/" + didc + "/tech.config.json"
	resp, err := http.Get(url)
	defer func() { _ = resp.Body.Close() }()
	bytes, err := ioutil.ReadAll(resp.Body)
	err = json.Unmarshal(bytes, &GlobalConfig)
	GlobalConfig.Env = denv
	if nil != err {
		logger.Error(err)
	}
}
