package report_form

import (
	"git.quantgroup.cn/DevOps/enoch/pkg/glog"
	"github.com/vrg0/go-common/util"
	"io/ioutil"
	"os"
	"runtime/debug"
	"time"
)

//定期报表，保存到指定文件夹
func RegularReport(dir string) {
	if !util.IsDir(dir) {
		return
	}

	go func() {
		defer func() {
			if err := recover(); err != nil {
				glog.Error(err, "\n", string(debug.Stack()))
			}

		}()

		timer := time.NewTimer(0)
		for {
			<-timer.C
			now := time.Now()

			run(now, dir)

			next := now.Add(time.Hour * 24)
			next = time.Date(next.Year(), next.Month(), next.Day(), 10, 0, 0, 0, next.Location())
			timer.Reset(next.Sub(now))
		}
	}()
}

func run(now time.Time, dir string) {
	fileNamePrefix := now.Format("2006-01-02")
	dir = dir + "/" + fileNamePrefix
	dirDay := dir + "/" + "day"
	dirWeek := dir + "/" + "week"
	if util.Exists(fileNamePrefix) {
		return
	} else {
		if err := os.Mkdir(dir, os.ModePerm); err != nil {
			glog.Error("创建dir失败:", dir, ":", err)
			return
		}
	}

	//周表
	if err := os.Mkdir(dirWeek, os.ModePerm); err != nil {
		glog.Error("创建dir失败:", dirWeek, ":", err)
		return
	} else {
		reportForm(now, dirWeek, 7)
	}

	//日表
	if err := os.Mkdir(dirDay, os.ModePerm); err != nil {
		glog.Error("创建dir失败:", dirDay, ":", err)
		return
	} else {
		reportForm(now, dirDay, 1)
	}
}

func reportForm(t time.Time, dir string, n int) {
	startTime := t.Add(-1 * time.Duration(t.Hour()) * time.Hour)
	startTime = startTime.Add(-1 * time.Duration(t.Minute()) * time.Minute)
	startTime = startTime.Add(-1 * time.Duration(t.Second()) * time.Second)
	startTime = startTime.Add(-1 * time.Duration(t.Nanosecond()))
	startTime = startTime.AddDate(0, 0, -n)
	endTime := startTime.AddDate(0, 0, n)

	sm := NewServiceMap(startTime, endTime)
	all := sm.ServiceMapReportForm()
	if err := ioutil.WriteFile(dir+"/all.html", []byte(all), os.ModePerm); err != nil {
		glog.Error("写入文件失败", dir+"/all.html", " ", err)
		return
	}
}
