package report_form

import (
	"encoding/json"
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/pkg/api-server"
	"git.quantgroup.cn/DevOps/enoch/pkg/email"
	"git.quantgroup.cn/DevOps/enoch/pkg/global"
	"github.com/valyala/fasthttp"
	"github.com/vrg0/go-common/util"
	"io/ioutil"
)

func show(ctx *fasthttp.RequestCtx) {
	long := ctx.UserValue("long").(string)
	y := ctx.UserValue("y").(string)
	m := ctx.UserValue("m").(string)
	d := ctx.UserValue("d").(string)
	name := ctx.UserValue("name").(string)

	if long != "day" && long != "week" {
		ctx.Response.SetStatusCode(fasthttp.StatusNotFound)
		ctx.Response.SetBodyString("page not found")
		return
	}
	if len(m) == 1 {
		m = "0" + m
	}
	if len(d) == 1 {
		d = "0" + d
	}
	date := fmt.Sprintf("%s-%s-%s", y, m, d)
	filePath := global.ReportFormDir + "/" + date + "/" + long + "/" + name + ".html"
	if !util.Exists(filePath) {
		ctx.Response.SetStatusCode(fasthttp.StatusBadRequest)
		ctx.Response.SetBodyString("超出查询范围")
		return
	}

	body, err := ioutil.ReadFile(filePath)
	if err != nil {
		ctx.Response.SetStatusCode(fasthttp.StatusBadRequest)
		ctx.Response.SetBodyString("读取文件失败")
	}

	ctx.Response.Header.SetContentType("text/html")
	ctx.Response.SetStatusCode(fasthttp.StatusOK)
	ctx.Response.SetBody(body)
}

func sendEmail(ctx *fasthttp.RequestCtx) {
	long := ctx.UserValue("long").(string)
	y := ctx.UserValue("y").(string)
	m := ctx.UserValue("m").(string)
	d := ctx.UserValue("d").(string)
	name := ctx.UserValue("name").(string)

	if long != "day" && long != "week" {
		ctx.Response.SetStatusCode(fasthttp.StatusNotFound)
		ctx.Response.SetBodyString("page not found")
		return
	}
	if len(m) == 1 {
		m = "0" + m
	}
	if len(d) == 1 {
		d = "0" + d
	}
	date := fmt.Sprintf("%s-%s-%s", y, m, d)
	filePath := global.ReportFormDir + "/" + date + "/" + long + "/" + name + ".html"
	if !util.Exists(filePath) {
		ctx.Response.SetStatusCode(fasthttp.StatusBadRequest)
		ctx.Response.SetBodyString("超出查询范围")
		return
	}

	body, err := ioutil.ReadFile(filePath)
	if err != nil {
		ctx.Response.SetStatusCode(fasthttp.StatusBadRequest)
		ctx.Response.SetBodyString("读取文件失败")
		return
	}

	emailList := make([]string, 0)
	if err := json.Unmarshal(ctx.Request.Body(), &emailList); err != nil {
		ctx.Response.SetStatusCode(fasthttp.StatusBadRequest)
		ctx.Response.SetBodyString("can not unmarshal body")
		return
	}

	email.SendEmail(fmt.Sprintf("服务健康状态表：%s_%s_%s", name, date, long), util.BytesString(body), emailList...)
}

func init() {
	//显示报表
	api_server.HandlerFunc(api_server.GET, "/show/:long/:y/:m/:d/:name", show)

	//发送邮件：周
	api_server.HandlerFunc(api_server.POST, "/send-email/:long/:y/:m/:d/:name", sendEmail)
}
