#! /bin/bash

# 监控主机的内存，当达到门限后重启influxdb服务

while :
do
	influxdb_pid=$(ps aux | grep ^influxdb | awk '{print $2;}')
	influxdb_mem=$(grep VmRSS /proc/${influxdb_pid}/status | awk '{print $2}')

	echo $(date):${influxdb_mem}

	if [ $influxdb_mem -gt "10485760" ]; then
		echo "influxdb restart"
		service influxdb restart
	fi

	sleep 2
done