package job

import (
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/service/alarm"
	"git.quantgroup.cn/DevOps/enoch/service/log"
	"github.com/robfig/cron"
	"net"
	"os"
	"time"
)

/**
	报警定时任务，每分钟执行一次
 */
func AutoAlarm() {

	if !checkIp("172.30.12.22"){
		return
	}
	c := cron.New()

	err := c.AddFunc("@every 1m", func() {
		logger.Info.Println("开始执行定时任务", time.Now().Minute())
		alarm.Load()
	})
	if err != nil {
		fmt.Print("err")
	}

	c.Start()
}

func checkIp(ip string) bool {
	addrs, err := net.InterfaceAddrs()
	if err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
	for _, address := range addrs {
		// 检查ip地址判断是否回环地址
		if ipnet, ok := address.(*net.IPNet); ok && !ipnet.IP.IsLoopback() {
			if ipnet.IP.To4() != nil {
				logger.Info.Println(ipnet.IP.String())
				return  ipnet.IP.String() == ip
			}
		}
	}
	return false
}
