package job

import (
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/service/alarm"
	"git.quantgroup.cn/DevOps/enoch/service/log"
	"github.com/robfig/cron"
	"time"
)

/**
	报警定时任务，每分钟执行一次
 */
func AutoAlarm() {
	c := cron.New()

	err := c.AddFunc("@every 1m", func() {
		logger.Info.Println("开始执行定时任务", time.Now().Minute())
		alarm.Load()
	})
	if err != nil {
		fmt.Print("err")
	}

	c.Start()
}
