package conf

import (
	"encoding/json"
	"fmt"
	"io/ioutil"
	"os"
)


var GlobalConfig = Config{}

func Init() {
	denv := os.Getenv("Denv")
	if "" == denv {
		denv = "dev"
	}
	var filename = "service/conf/" + denv + "/conf.json"
	bytes, err := ioutil.ReadFile(filename)
	if nil != err {
		fmt.Println("启动报错：未找到对应的环境变量配置。env: " + filename)
	}
	err = json.Unmarshal(bytes, &GlobalConfig)
	GlobalConfig.Env = denv
	if nil != err {
		fmt.Println(err)
	}
}
