package report_form

import (
	"encoding/json"
	"git.quantgroup.cn/DevOps/enoch/pkg/email"
	"git.quantgroup.cn/DevOps/enoch/pkg/global"
	"git.quantgroup.cn/DevOps/enoch/pkg/glog"
	"github.com/vrg0/go-common/util"
	"io/ioutil"
	"runtime/debug"
	"time"
)

var (
	receiverList = make([]string, 0)
)

func init() {
	global.Config.Watch(global.NamespaceApplication, "report.form.receiver", func(oldCfg string, newCfg string) {
		rList := make([]string, 0)
		if err := json.Unmarshal([]byte(newCfg), &rList); err != nil {
			glog.Error("can not unmarshal json:", err, " ", newCfg)
			return
		}
		receiverList = rList
	})
}

//保存服务报表的目录
func RegularReport(dir string) {
	if !util.IsDir(dir) {
		return
	}

	go func() {
		defer func() {
			if err := recover(); err != nil {
				glog.Error(err, "\n", string(debug.Stack()))
			}
		}()

		timer := time.NewTimer(0)
		for {
			<-timer.C
			now := time.Now()

			//报表
			run(now, dir)

			next := now.Add(time.Hour * 24)
			next = time.Date(next.Year(), next.Month(), next.Day(), 10, 0, 0, 0, next.Location())
			timer.Reset(next.Sub(now))
		}
	}()
}

func run(now time.Time, dir string) {
	fileNamePrefix := now.Format("2006-01-02")

	//周表
	if now.Weekday() == time.Monday {
		sm := GeneralTableNewSM(7)

		//总表
		fileName := dir + "/" + fileNamePrefix + "_week.txt"
		if !util.Exists(fileName) {
			body := GeneralTableRun(sm)
			if err := ioutil.WriteFile(fileName, []byte(body), 0644); err != nil {
				glog.Error("报表写入文件失败：", fileName, err)
				glog.Info(body)
			}
			email.SendEmail("服务监控状态总表-"+fileNamePrefix, body, receiverList...)
		}
		glog.Info("每周总表报表完成:", fileName)

		//分表
		for name, service := range sm.serviceMap {
			fileName := dir + "/" + fileNamePrefix + "_" + name + "_week.txt"
			if !util.Exists(fileName) {
				body := SubTableRun(service)
				if err := ioutil.WriteFile(fileName, []byte(body), 0644); err != nil {
					glog.Error("报表写入文件失败：", fileName, err)
					glog.Info(body)
				}
				//发送给服务负责人
			}
		}
		//TODO
	}

	//日表
	//TODO
}
