package report_form

import (
	"testing"
	"time"
)

func TestNewService(t *testing.T) {
	const (
		serviceName = "gu-bei"
	)

	s := NewService(serviceName, time.Now().Add(time.Hour*-100), time.Now())
	t.Log(s.GetCount())
	t.Log(s.GetSumDuration())
	t.Log(s.GetAverageDuration())
	median, ok := s.GetMaxMedianDurationPath()
	if ok {
		t.Log("median_max_path:", median.GetPath())
	}

	average, ok := s.GetMaxAverageDurationPath()
	if ok {
		t.Log("average_max_path:", average.GetPath())
	}
}
