package service_check

import (
	"fmt"
	"git.quantgroup.cn/DevOps/enoch/pkg/global"
	"github.com/influxdata/influxdb/client/v2"
)

var sqlMap = map[string]string{
	"yesterday_count":      "select count(traceId) from trace_info where time > now() - 1d25m and time < now() - 1d group by sys_name,path,time(5m) fill(0);",
	"count":                "select count(traceId) from trace_info where time > now() - 25m group by sys_name,path,time(5m) fill(1);",
	"yesterday_path_count": "select count(traceId) from trace_info where time > now() - 1d25m and time < now() - 1d group by sys_name,path,time(5m) fill(0);",
	"path_count":           "select count(traceId) from trace_info where time > now() - 25m group by sys_name,path,time(5m) fill(1)",
	"apdex":                "select (sum(sat)+sum(tol))/sum(ct_all) as cu from apdex where time > now() - 7m30s and time < now() - 1m59s group by sys_name,time(1m) fill(0);",
	"cpu":                  "select last(system_load_average)/last(processors) from machine_info where time > now() - 5m group by sys_name, host,time(1m) fill(1);",
	"mem":                  "select last(mem_free)/last(mem_tol) from machine_info where time > now() - 5m group by sys_name,host,time(1m) fill(0);",
	"disk":                 "select last(disk_free)/last(disk_tol) from machine_info where time > now() - 3m group by sys_name,host,time(1m) fill(0);",
}

func query(sql string) (*client.Response, error) {
	config := client.HTTPConfig{
		Addr: global.InfluxDbAddress,
	}

	connect, err := client.NewHTTPClient(config)
	defer func() { _ = connect.Close() }()
	if err != nil {
		return nil, err
	}

	rtn, err := connect.Query(client.NewQuery(sql, global.InfluxDbName, ""))
	if err != nil {
		return nil, err
	}

	return rtn, nil
}

type item struct {
	sql       string
	resultMap map[string]float64 //sql的执行结果，按照sys_name分类
}

func newItem(sql string) *item {
	return &item{
		sql:       sql,
		resultMap: make(map[string]float64),
	}
}

func (i *item) Run() {
	resp, err := query(i.sql)
	if err != nil {
		return
	}
	for _, r := range resp.Results {
		for _, row := range r.Series {
			for _, v := range row.Values {
				fmt.Println(row.Tags)
				fmt.Println(v)
			}
		}
	}
}

func (i *item) Clean() {
	i.resultMap = make(map[string]float64)
}

type Interpreter struct {
	itemMap map[string]*item
}

func NewInterpreter() *Interpreter {
	return &Interpreter{itemMap: make(map[string]*item)}
}

//(((x1>=10)&&(x2<=20))||x3=0)
// ()                   //调整优先级
// > < = >= <= && ||    //运算符
// abc                  //变量，对应itemMap中sql的执行结果
// 1.11                 //数值，统一为float64类型
func (i *Interpreter) Explain(service string, pattern string) bool {
	return false
}

//运行sql
func (i *Interpreter) RunItem() {
	for _, im := range i.itemMap {
		im.Clean()
		im.Run()
	}
}

//添加项
func (i *Interpreter) AddItem(name string, sql string) {
	i.itemMap[name] = newItem(sql)
}
