package consumer

type TraceMsg struct {
	TraceId        string         `json:"traceId"`
	Id             string         `json:"id"`
	Kind           string         `json:"kind"`
	Name           string         `json:"name"`
	Timestamp      int64          `json:"timestamp"`
	ParentId       string         `json:"parentId"`
	Duration       int            `json:"duration"`
	LocalEndpoint  localEndpoint  `json:"localEndpoint"`
	RemoteEndpoint remoteEndpoint `json:"remoteEndpoint"`
	Tags           tags           `json:"tags"`
	Shared         bool           `json:"shared"`
}

type localEndpoint struct {
	ServiceName string `json:"serviceName"`
	Ipv4        string `json:"ipv4"`
}
type remoteEndpoint struct {
	Ipv4 string `json:"ipv4"`
	Port int    `json:"port"`
}

type tags struct {
	HttpMethod          string `json:"http.method"`
	HttpPath            string `json:"http.path"`
	MvcControllerClass  string `json:"mvc.controller.class"`
	MvcControllerMethod string `json:"mvc.controller.method"`
}
