package alarm

type StrategyType int8
type NoticeSender int8

const (
	SERVICE StrategyType = 1 //监控服务的策略
	MACHINE StrategyType = 2 //监控机器的策略
	COMMON  StrategyType = 3 //通用策略
)

const (
	DING_DING NoticeSender = 1 //钉钉
	MAIL NoticeSender = 2 //邮箱
)


type Strategy struct {
	Name               string              `json:"name"` //策略名称
	Sql                string              `json:"sql"`//sql 每条sql用 ; 分割
	SqlLen             int                 `json:"sql_len"` //包含的sql条数，
	Type               StrategyType        `json:"type"` //策略类型
	Operator           string              `json:"operator"` //结果比较方式
	AlterValue         []string            `json:"alter_value"` //触发点
	Tag                []string            `json:"tag"` //sql中需要展示的tag名称,将最细粒度的tag名称放在array[0], sys_name>host
	IgnoreTag          map[string]bool     `json:"ignore_tag"` //需要忽略的服务、主机
	PersonalAlterValue map[string][]string `json:"personal_alter_value"` //针对服务、主机个性化触发点配置
	NoDataAlter bool `json:"no_data_alter"` //空值报警
	Notice Notice `json:"notice"` //通知方式
}

type Notice struct {
	 Sender NoticeSender `json:"sender"` //发送方式 dingDing(1)/mail(2)
	 Interval int64 `json:"interval"` //相同的(同服务/主机,同策略)报警发送间隔 单位 秒
	 Receiver []string //接收者，dingDing 则为webHookUrl, mail 则为邮箱
}

