package alarm

import (
	"encoding/json"
	"git.quantgroup.cn/DevOps/enoch/service/conf"
	"git.quantgroup.cn/DevOps/enoch/service/data"
	"git.quantgroup.cn/DevOps/enoch/service/log"
	"io/ioutil"
)

func Load() {
	config,err := ioutil.ReadFile(conf.GlobalConfig.StrategyConfPath)
	if err != nil {
		logger.Error.Print("!!!轮训监控，未找到配置文件!!!")
		return
	}

	strategies := make([]Strategy, 0)
	err = json.Unmarshal(config, &strategies)

	if err != nil {
		logger.Error.Printf("!!!策略文件格式错误:%s!!!\n", err)
		return
	}

	if !CheckArray(strategies) {
		logger.Error.Print("!!!策略文件未通过校验!!!")
		return
	}

	sql := BuildSql(strategies)
	result := data.QueryMonitor(sql)
	DealResult(result, strategies)

}
