package api_server

import (
	"github.com/valyala/fasthttp"
	"strings"
	"testing"
)

func init() {
	//正确执行的测试场景
	HandlerFunc(GET, "/hello", func(ctx *fasthttp.RequestCtx) {
		ctx.Response.SetBodyString("hello!")
	})

	//panic测试场景
	HandlerFunc(GET, "/panic", func(ctx *fasthttp.RequestCtx) {
		panic("panic_test")
	})
}

//测试panic回调函数是否好用
func TestHandlerFuncPanic(t *testing.T) {
	ListenAndServe()

	if _, body, err := fasthttp.Get(nil, "http://127.0.0.1:5555/panic"); err != nil {
		t.Error(err)
	} else if !strings.Contains(string(body), "panic_test") {
		t.Error("recover panic fatal")
	}
}

//测试http-server是否启动
func TestListenAndServe(t *testing.T) {
	ListenAndServe()

	if _, _, err := fasthttp.Get(nil, "http://127.0.0.1:5555/hello"); err != nil {
		t.Error(err)
	}
}

//不在init()中执行会报panic
func TestHandlerFunc(t *testing.T) {
	defer func() {
		if err := recover(); err != nil {
			if errStr, ok := err.(string); !ok || errStr != "HandlerFunc must be execute in init()" {
				t.Error("HandlerFunc Err")
			}
		}
	}()
	HandlerFunc(GET, "/test", func(ctx *fasthttp.RequestCtx) {
		ctx.Response.SetBodyString("test!")
	})
}
