package alarm

type StrategyType int8

const (
	SERVICE StrategyType = 1 //监控服务的策略
	MACHINE StrategyType = 2 //监控机器的策略
	COMMON  StrategyType = 3 //通用策略

)

type Strategy struct {
	Name               string              `json:"name"`
	Sql                string              `json:"sql"`
	SqlLen             int                 `json:"sql_len"`
	Type               StrategyType        `json:"type"`
	Operator           string              `json:"operator"`
	AlterValue         []string            `json:"alter_value"`
	Tag                []string            `json:"tag"`
	IgnoreTag          map[string]bool     `json:"ignore_tag"`
	PersonalAlterValue map[string][]string `json:"personal_alter_value"`
}

