package alarm

import (
	"git.quantgroup.cn/DevOps/enoch/service/log"
	"strconv"
)

type Operator interface {
	Less(alter string, real string)
	Grater(alter string, real string)
	Equal(alter string, real string)
	Between(floor string, ceil string, real string)
	ComparedWithSame(old string, current string, alter string)
}

type Compare struct {
}

/**
	real < alter
 */
func (Compare) Less(alter string, real string) bool {
	return real < alter
}

/**
	real > alter
 */
func (Compare) Greater(alter string, real string) bool {
	return real > alter
}

/**
	real = alter
 */
func (Compare) Equal(alter string, real string) bool {
	return real == alter
}

func (Compare) Between(floor string, ceil string, real string) bool {
	return floor < real && ceil > real
}

/**
	同比超过alter
 */
func (Compare) ComparedWithSame(alter string, old string, current string) bool {
	cf := parseToFloat(current)
	of := parseToFloat(old)
	return (cf - of)/of > parseToFloat(alter)
}

func parseToFloat(value string) float64 {
	rs, err := strconv.ParseFloat(value, 64)
	if nil != err {
		logger.Error.Println(err)
	}
	return rs
}
