package alarm

import (
	"encoding/json"
	"git.quantgroup.cn/DevOps/enoch/service/log"
	"io/ioutil"
)

func Load() {
	data,err := ioutil.ReadFile("service/conf/dev/tsconfig.json")
	if err != nil {
		logger.Error.Fatal("未找打配置文件")
	}

	strategies := make([]Strategy, 0)
	err = json.Unmarshal(data, &strategies)

	if err != nil {
		logger.Error.Fatal("策略文件格式错误:", err)
	}

	if !CheckArray(strategies) {
		logger.Error.Fatal("策略文件未通过校验")
	}

	sql := BuildSql(strategies)
	logger.Info.Println(sql)
	result := QueryMonitor(sql)
	DealResult(result, strategies)

}
